/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.size;

import de.duehl.swing.ui.elements.size.SizeChooser;
import java.awt.Component;
import java.awt.Point;
import java.util.List;
import javax.swing.JButton;

public class ChangeButtonWithSizeChooser {
    private final Point parentLocation;
    private final String sizeDescription;
    private final int rows;
    private final int columns;
    private final List<Integer> possibleSizes;
    private int size;
    private final JButton sizeChangeButton;
    private boolean differentSizesAreOk;

    public ChangeButtonWithSizeChooser(Point point, String string, int n, int n2, List<Integer> list) {
        this.parentLocation = point;
        this.sizeDescription = string;
        this.rows = n;
        this.columns = n2;
        this.possibleSizes = list;
        this.size = list.get(0);
        this.sizeChangeButton = new JButton();
        this.differentSizesAreOk = false;
        this.initSizeColorButton();
    }

    private void initSizeColorButton() {
        this.setSizeButtonText();
        this.sizeChangeButton.addActionListener(actionEvent -> this.selectSize());
    }

    private void selectSize() {
        String string = this.sizeDescription;
        SizeChooser sizeChooser = new SizeChooser(this.size, string, this.rows, this.columns, this.possibleSizes, this.parentLocation, null);
        if (this.differentSizesAreOk) {
            sizeChooser.diffenrentSizesAreOk();
        }
        sizeChooser.setSize(this.size);
        sizeChooser.setVisible(true);
        int n = sizeChooser.getSize();
        if (n != -1) {
            this.size = n;
            this.setSizeButtonText();
        }
    }

    private void setSizeButtonText() {
        this.sizeChangeButton.setText(this.sizeDescription + " \u00e4ndern, momentan " + this.size);
    }

    public void differentSizesAreOk() {
        this.differentSizesAreOk = true;
    }

    public Component getSizeChangeButton() {
        return this.sizeChangeButton;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
        this.setSizeButtonText();
    }
}

