/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.watch;

import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.elements.watch.WatchBaseLabel;

class WatchActualisationRunnable
implements Runnable {
    private static final int SLEEP_TIME = 50;
    private volatile boolean actualisationRunning;
    private final WatchBaseLabel watchBaseLabel;
    private volatile int sleepTimeMillis;

    public WatchActualisationRunnable(WatchBaseLabel watchBaseLabel) {
        this.watchBaseLabel = watchBaseLabel;
        this.sleepTimeMillis = 50;
    }

    @Override
    public void run() {
        this.actualisationRunning = true;
        this.loop();
    }

    private void loop() {
        while (this.actualisationRunning) {
            this.watchBaseLabel.setWatchText();
            this.watchBaseLabel.repaint();
            SystemTools.sleep(this.sleepTimeMillis);
        }
    }

    public void stop() {
        this.actualisationRunning = false;
    }

    public void setSleepTimeMillis(int n) {
        this.sleepTimeMillis = n;
    }
}

