/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.watch;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.datetime.time.watch.WatchBase;
import de.duehl.swing.ui.elements.watch.WatchActualisationRunnable;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class WatchBaseLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private volatile String startText;
    private volatile String endText;
    private final WatchBase watch;
    private WatchActualisationRunnable actualisationRunnable;
    private boolean showSeconds;

    public WatchBaseLabel() {
        this("", new StopWatch(), "");
    }

    public WatchBaseLabel(String string, WatchBase watchBase, String string2) {
        this.startText = string;
        this.watch = watchBase;
        this.endText = string2;
        this.showSeconds = true;
        this.createRunnableAndStartActualisationThread();
    }

    protected final void createRunnableAndStartActualisationThread() {
        this.actualisationRunnable = new WatchActualisationRunnable(this);
        Thread thread = new Thread(this.actualisationRunnable);
        thread.start();
    }

    public final void stopActualisationRunnable() {
        this.actualisationRunnable.stop();
    }

    public final void setStartText(String string) {
        this.startText = string;
        this.setWatchText();
    }

    public final void setEndText(String string) {
        this.endText = string;
        this.setWatchText();
    }

    public final void setSleepTimeMillis(int n) {
        this.actualisationRunnable.setSleepTimeMillis(n);
    }

    public final void hideSeconds() {
        this.showSeconds = false;
    }

    final void setWatchText() {
        SwingUtilities.invokeLater(() -> this.setStopWatchTextInEdt());
    }

    private void setStopWatchTextInEdt() {
        this.setText(this.createWatchLabelText());
    }

    protected final String createWatchLabelText() {
        String string = this.watch.getTime();
        if (!this.showSeconds) {
            string = string.substring(0, string.length() - 3);
        }
        return this.startText + string + this.endText;
    }

    public final String getTime() {
        return this.watch.getTime();
    }

    @Override
    public String toString() {
        return "WatchBaseLabel [" + this.createWatchLabelText() + "]";
    }
}

