/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.layout.card;

import de.duehl.swing.ui.layout.card.Card;
import de.duehl.swing.ui.layout.card.CardDebug;
import de.duehl.swing.ui.layout.card.CardSwitcher;
import de.duehl.swing.ui.layout.card.Cards;
import java.awt.CardLayout;
import javax.swing.JPanel;

public class CardHandling {
    private final CardLayout cardLayout;
    private final JPanel cardPanel;
    private final Cards cards;
    private Card currentCard;
    private boolean interrupted;
    private boolean quitDialogStarted;
    private boolean switchCardLater;

    public CardHandling(Cards cards) {
        this.cards = cards;
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.currentCard = cards.getFirstCard();
        this.interrupted = false;
        this.quitDialogStarted = false;
        this.switchCardLater = false;
        CardDebug.say("currentCard: " + this.currentCard.getName());
    }

    public JPanel getCardPanel() {
        return this.cardPanel;
    }

    public void addAllCardsToPanel(CardSwitcher cardSwitcher) {
        this.cards.addAllCardsToPanel(this.cardPanel, cardSwitcher);
    }

    public synchronized void switchCard() {
        CardDebug.say("called. interrupted = " + this.interrupted + ", quitDialogStarted = " + this.quitDialogStarted + ", switchCardLater = " + this.switchCardLater);
        if (this.interrupted) {
            CardDebug.say("aborted because interrupted");
            return;
        }
        if (this.quitDialogStarted) {
            CardDebug.say("aborted because quit dialog was started");
            this.switchCardLater = true;
            return;
        }
        this.switchCardLater = false;
        CardDebug.say("R\u00e4ume Karte " + this.currentCard.getName() + " auf...");
        Card card = this.currentCard;
        card.cleanUp();
        CardDebug.say("Ermittle n\u00e4chste Karte ...");
        this.currentCard = this.cards.getNext(card);
        CardDebug.say("N\u00e4chste Karte: " + this.currentCard.getName());
        this.cardLayout.show(this.cardPanel, this.currentCard.getName());
        this.currentCard.runWhenShown(card);
        this.cardPanel.validate();
    }

    public synchronized void quit() {
        CardDebug.say("called");
        this.interrupted = true;
        this.currentCard.quit();
        System.exit(1);
    }

    public synchronized void quitDialogStarted() {
        CardDebug.say("called");
        this.quitDialogStarted = true;
    }

    public synchronized void quitDialogAborted() {
        CardDebug.say("called");
        this.quitDialogStarted = false;
        if (this.switchCardLater) {
            this.switchCard();
        }
    }
}

