/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.move;

import de.duehl.swing.ui.move.VerticalMoveButtons;
import de.duehl.swing.ui.move.data.VerticalMoveButtonsUser;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class SwitchableVerticalMoveButtons {
    private final VerticalMoveButtons moveButtons;
    private final JPanel panel;
    private boolean moveButtonsShown;

    public SwitchableVerticalMoveButtons(VerticalMoveButtonsUser verticalMoveButtonsUser) {
        this.moveButtons = new VerticalMoveButtons(verticalMoveButtonsUser);
        this.panel = new JPanel();
        this.moveButtonsShown = false;
        this.init();
    }

    private void init() {
        this.initSwitchableMoveUpAndDownButtonsPanel();
    }

    private void initSwitchableMoveUpAndDownButtonsPanel() {
        this.panel.setLayout(new BorderLayout());
    }

    public void showMoveButtons(boolean bl) {
        if (bl) {
            this.showMoveButtons();
        } else {
            this.hideMoveButtons();
        }
    }

    private void showMoveButtons() {
        this.panel.removeAll();
        this.panel.add((Component)this.moveButtons.getPanel(), "Center");
        this.panel.repaint();
        this.moveButtonsShown = true;
    }

    private void hideMoveButtons() {
        this.panel.removeAll();
        this.panel.add((Component)new JPanel(), "Center");
        this.panel.repaint();
        this.moveButtonsShown = false;
    }

    public void setUpAndDownButtonColorsAndEnabled() {
        this.moveButtons.setUpAndDownButtonColorsAndEnabled();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean isMoveButtonsShown() {
        return this.moveButtonsShown;
    }
}

