/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tables;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;

public class CellFocusLoosingTable
extends JTable {
    private static final long serialVersionUID = 1L;

    public CellFocusLoosingTable() {
        this.addLoosingCellEditor();
        this.addLoosingFocusListener();
    }

    private void addLoosingCellEditor() {
        JTextField jTextField = this.createCellEditorField();
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        this.setDefaultEditor(Object.class, defaultCellEditor);
    }

    private JTextField createCellEditorField() {
        JTextField jTextField = new JTextField(10);
        jTextField.setBorder(new EmptyBorder(1, 1, 1, 1));
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CellFocusLoosingTable.this.editorFocusLost(focusEvent);
            }
        });
        return jTextField;
    }

    private void editorFocusLost(FocusEvent focusEvent) {
        Component component;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
            tableCellEditor.cancelCellEditing();
        }
        if (!this.equals(component = focusEvent.getOppositeComponent())) {
            this.clearSelection();
        }
    }

    private void addLoosingFocusListener() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CellFocusLoosingTable.this.tableFocusLost(focusEvent);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        });
    }

    private void tableFocusLost(FocusEvent focusEvent) {
        Container container;
        Component component = focusEvent.getOppositeComponent();
        if (component != null && (container = component.getParent()) != null && !container.equals(this)) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                tableCellEditor.cancelCellEditing();
            }
            this.clearSelection();
        }
    }
}

