/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs;

import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.tabs.ChangeStateDisplayer;
import de.duehl.swing.ui.tabs.close.CloseButtonReaktor;
import de.duehl.swing.ui.tabs.close.CloseTabButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Tabulator
extends JPanel
implements ChangeStateDisplayer {
    private static final long serialVersionUID = 1L;
    private final String tabIdentifier;
    private String name;
    private JLabel nameLabel;
    private final boolean showCloseButton;
    private CloseTabButton closeButton;
    private Colorizer colorizer;
    private Color originalForeground;
    private boolean changeName;

    public Tabulator(String string, String string2) {
        this(string, string2, Tabulator.createDoNothingCloseReaktor(), true);
    }

    public Tabulator(String string, String string2, boolean bl) {
        this(string, string2, Tabulator.createDoNothingCloseReaktor(), bl);
    }

    public Tabulator(String string, String string2, CloseButtonReaktor closeButtonReaktor) {
        this(string, string2, closeButtonReaktor, null, true);
    }

    public Tabulator(String string, String string2, CloseButtonReaktor closeButtonReaktor, boolean bl) {
        this(string, string2, closeButtonReaktor, null, bl);
    }

    public Tabulator(String string, String string2, CloseButtonReaktor closeButtonReaktor, Colorizer colorizer) {
        this(string, string2, closeButtonReaktor, colorizer, true);
    }

    public Tabulator(String string, String string2, CloseButtonReaktor closeButtonReaktor, Colorizer colorizer, boolean bl) {
        super(new FlowLayout(0, 0, 0));
        this.tabIdentifier = string;
        this.name = string2;
        this.colorizer = colorizer;
        this.showCloseButton = bl;
        this.changeName = true;
        this.setColors(this);
        this.initGui(closeButtonReaktor);
    }

    private static CloseButtonReaktor createDoNothingCloseReaktor() {
        return new CloseButtonReaktor(){

            @Override
            public void closeButtonPressed(String string) {
            }
        };
    }

    public void doNotChangeName() {
        this.changeName = false;
    }

    private void setColors(Component component) {
        if (null != this.colorizer) {
            this.colorizer.setColors(component);
        }
    }

    private void initGui(CloseButtonReaktor closeButtonReaktor) {
        this.setOpaque(false);
        this.nameLabel = new JLabel();
        this.setColors(this.nameLabel);
        this.nameLabel.setText(this.name);
        this.add(this.nameLabel);
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.closeButton = new CloseTabButton(this.tabIdentifier, closeButtonReaktor);
        this.setColors(this.closeButton);
        if (this.showCloseButton) {
            this.add(this.closeButton);
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public String getTabulatorName() {
        return this.name;
    }

    @Override
    public void updateName(String string) {
        if (this.changeName) {
            this.name = string;
            this.nameLabel.setText(string);
        }
    }

    @Override
    public void signChangedState() {
        if (null != this.originalForeground) {
            this.originalForeground = this.nameLabel.getForeground();
        }
        this.nameLabel.setForeground(Color.RED);
        this.nameLabel.validate();
    }

    @Override
    public void signUnchangedState() {
        if (null != this.colorizer) {
            this.setColors(this.nameLabel);
        } else if (null != this.originalForeground) {
            this.nameLabel.setForeground(this.originalForeground);
        } else {
            this.nameLabel.setForeground(Color.BLACK);
        }
        this.nameLabel.validate();
    }

    public void reactivate() {
        this.closeButton.reactivate();
    }

    @Override
    public String toString() {
        return "Tabulator [tabIdentifier=" + this.tabIdentifier + ", name=" + this.name + "]";
    }
}

