/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.grammar.table;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.grammar.table.GrammarTableHtmlCreator;
import de.duehl.vocabulary.japanese.grammar.table.GrammarTableRowCreator;
import de.duehl.vocabulary.japanese.grammar.table.data.GrammarTableType;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.GrammarTableCreatorDialog;
import java.util.ArrayList;
import java.util.List;

public class GrammarTableCreator {
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private String tableTitle;
    private OwnList ownList;
    private GrammarTableType grammarTableType;
    private List<String> searchWords;
    private List<List<Vocable>> listOfVocablesInRow;
    private String html;
    private String filename;
    private boolean creationStarted;

    public GrammarTableCreator(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
    }

    public void create() {
        GrammarTableCreatorDialog grammarTableCreatorDialog = new GrammarTableCreatorDialog(this.dataStructures, this.uiObjects);
        grammarTableCreatorDialog.setVisible(true);
        if (grammarTableCreatorDialog.isApplied()) {
            this.creationStarted = true;
            this.tableTitle = grammarTableCreatorDialog.getTableTitle();
            this.ownList = grammarTableCreatorDialog.getOwnList();
            this.grammarTableType = grammarTableCreatorDialog.getGrammarTableType();
            this.searchWords = grammarTableCreatorDialog.getSearchWords();
            this.createTable();
        } else {
            this.creationStarted = false;
        }
    }

    private void createTable() {
        boolean bl = this.determineFormVocables();
        if (bl) {
            this.createHtml();
            this.askUserForFilename();
            this.saveFile();
            this.showInBrowser();
        }
    }

    private boolean determineFormVocables() {
        GrammarTableRowCreator grammarTableRowCreator = new GrammarTableRowCreator(this.dataStructures, this.ownList, this.grammarTableType, this.searchWords, this.uiObjects);
        grammarTableRowCreator.create();
        if (grammarTableRowCreator.isCreated()) {
            this.listOfVocablesInRow = grammarTableRowCreator.getListOfVocablesInRow();
            return true;
        }
        this.listOfVocablesInRow = new ArrayList<List<Vocable>>();
        return false;
    }

    private void createHtml() {
        GrammarTableHtmlCreator grammarTableHtmlCreator = new GrammarTableHtmlCreator(this.listOfVocablesInRow, this.tableTitle, this.searchWords, this.dataStructures.getOptions());
        grammarTableHtmlCreator.create();
        this.html = grammarTableHtmlCreator.getHtml();
    }

    private void askUserForFilename() {
        this.filename = GuiTools.saveFileAs(this.uiObjects.getWindowAsComponent(), SystemTools.getHomeDirectory(), GuiTools.createHtmlFileFilter());
    }

    private void saveFile() {
        if (!this.filename.isBlank()) {
            FileHelper.writeTextToFile(this.html, this.filename, Charset.UTF_8);
        }
    }

    private void showInBrowser() {
        if (!this.filename.isBlank()) {
            SystemTools.openInStandardProgram(this.filename);
        }
    }

    public boolean isCreationStarted() {
        return this.creationStarted;
    }
}

