/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.system.SystemTools;
import de.duehl.basics.version.Version;
import de.duehl.swing.logic.Quitter;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.version.NewsHelper;
import de.duehl.vocabulary.japanese.VocabularyTrainerVersion;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.common.persistence.GrammarTableHeaderPersistenceHelper;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.common.website.update.vocables.VocablesActualityChecker;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.grammar.AdjectiveSearchWords;
import de.duehl.vocabulary.japanese.grammar.VerbSearchWords;
import de.duehl.vocabulary.japanese.io.AllKanjiSetsWriter;
import de.duehl.vocabulary.japanese.logic.wrongtested.WrongTestedVocables;
import de.duehl.vocabulary.japanese.startup.logic.StartupLoader;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.website.update.ownlists.GroupsOfOwnListsFromWebsiteImporter;
import de.duehl.vocabulary.japanese.website.update.ownlists.OwnListGroupsUpdater;
import de.duehl.vocabulary.japanese.website.update.ownlists.interest.OwnListVersionsAndInterestUpdater;
import de.duehl.vocabulary.japanese.website.update.program.ProgramUpdatableChecker;
import de.duehl.vocabulary.japanese.website.update.vocables.VocablesUpdatableChecker;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class VocabularyTrainerLogic
implements Quitter {
    private final Version vocabularyTrainerVersion = new VocabularyTrainerVersion().getVersion();
    private final SessionManager sessionManager = new SessionManager(this.vocabularyTrainerVersion);
    private final Options options = this.loadOptions();
    private final VocabularyTrainerGui gui;
    private FumikoDataStructures dataStructures;
    private String vocabularyLoadMessage;
    private String startupLog;
    private List<String> startupWarnings;
    private boolean checkingNewVersionsOnStartUp;
    private boolean startupExceptionOccured;

    public VocabularyTrainerLogic() {
        this.checkForChangedGrammarTableForms();
        this.gui = new VocabularyTrainerGui(this, this.options);
        this.checkingNewVersionsOnStartUp = false;
    }

    private Options loadOptions() {
        try {
            return this.sessionManager.load();
        }
        catch (Exception exception) {
            if (this.gui == null) {
                System.out.println("Fehler beim Laden der Optionen: " + exception.getMessage());
                return new Options(this.vocabularyTrainerVersion);
            }
            ErrorHandler errorHandler = this.gui.createErrorHandler();
            errorHandler.error(exception.getMessage(), exception);
            return new Options(this.vocabularyTrainerVersion);
        }
    }

    private void checkForChangedGrammarTableForms() {
        GrammarTableHeaderPersistenceHelper.checkForChangedMyForms(this.options.getGrammarTableVerbHeadersMap(), "den Verben", VerbSearchWords.SORTED_VERB_SEARCH_WORDS);
        GrammarTableHeaderPersistenceHelper.checkForChangedMyForms(this.options.getGrammarTableIAdjectiveHeadersMap(), "den I-Adjektiven", AdjectiveSearchWords.SORTED_I_ADJEKTIVE_SEARCH_WORDS);
        GrammarTableHeaderPersistenceHelper.checkForChangedMyForms(this.options.getGrammarTableNaAdjectiveHeadersMap(), "den NA-Adjektiven", AdjectiveSearchWords.SORTED_NA_ADJEKTIVE_SEARCH_WORDS);
    }

    public void saveOptions() {
        try {
            this.tryToSaveOption();
        }
        catch (Exception exception) {
            if (this.gui != null) {
                ErrorHandler errorHandler = this.gui.createErrorHandler();
                errorHandler.error(exception.getMessage(), exception);
            }
            throw new RuntimeException("Fehler beim Speichern der Optionen!", exception);
        }
    }

    private void tryToSaveOption() {
        this.storeToOptions();
        if (this.sessionManager != null) {
            this.sessionManager.save();
        }
    }

    private void storeToOptions() {
        if (null != this.options && !this.startupExceptionOccured && this.gui != null) {
            this.options.setStringSelectionFontSize(this.gui.getStringSelectionFontSize());
            this.options.setStringSelectionLabelFontSize(this.gui.getStringSelectionLabelFontSize());
            this.gui.storeShownTabIndices();
        }
    }

    public void run() {
        if (this.isInitialDirectoryChoosingNecessary()) {
            this.initialDirectoryChoosing();
        }
        this.startup();
        if (!this.startupExceptionOccured) {
            this.perhapsShowNews();
            this.actualizeStringSelectionSize();
            this.actualizeStringSelectionLabelSize();
            this.initGuiWithDataStructures();
            this.showLoadMessageInStatusBar();
            this.gui.setVisible(true);
            this.checksForNewVersionsAtStart();
            if (this.options.isShowWarningsAfterStart()) {
                this.gui.showStartupWarningsIfAny();
            }
        }
    }

    private boolean isInitialDirectoryChoosingNecessary() {
        String string = this.options.getVocabulariesPath();
        return string.isBlank() || !FileHelper.isDirectory(string);
    }

    private void initialDirectoryChoosing() {
        String string = SystemTools.getHomeDirectory();
        String string2 = GuiTools.openDirectory(string, "Bitte das Verzeichnis mit den Vokabeln w\u00e4hlen", this.gui.getWindowAsComponent());
        if (FileHelper.isDirectory(string2)) {
            this.options.setVocabulariesPath(string2);
        } else {
            System.exit(1);
        }
    }

    private void startup() {
        this.startupExceptionOccured = false;
        this.reallyStartup();
    }

    private void reallyStartup() {
        try {
            this.tryStartUp();
        }
        catch (Exception exception) {
            this.reallyQuit();
            this.gui.createErrorHandler().error("Es trat ein Fehler beim Startup auf", exception);
            this.startupExceptionOccured = true;
        }
    }

    private void tryStartUp() {
        StartupLoader startupLoader = new StartupLoader(this.gui, this.options);
        startupLoader.load();
        this.dataStructures = startupLoader.getDataStructures();
        this.vocabularyLoadMessage = startupLoader.getVocabularyLoadMessage();
        this.startupLog = startupLoader.getStartUpLog();
        this.startupWarnings = startupLoader.getStartupWarnings();
    }

    private void showLoadMessageInStatusBar() {
        this.gui.setMessageLater(this.vocabularyLoadMessage);
    }

    public String getStartupLog() {
        return this.startupLog;
    }

    public List<String> getStartupWarnings() {
        return this.startupWarnings;
    }

    private void perhapsShowNews() {
        NewsHelper newsHelper = new NewsHelper(this.vocabularyTrainerVersion, this.options.getLastUsedVersion(), this.gui.getChanges(), this.gui.getProgramImage(), this.gui.getLocation());
        newsHelper.perhapsShowNews();
    }

    private void actualizeStringSelectionSize() {
        int n = this.options.getStringSelectionFontSize();
        if (n > -1) {
            this.gui.setStringSelectionFontSize(n);
        }
    }

    private void actualizeStringSelectionLabelSize() {
        int n = this.options.getStringSelectionLabelFontSize();
        if (n > -1) {
            this.gui.setStringSelectionLabelFontSize(n);
        }
    }

    private void initGuiWithDataStructures() {
        this.gui.initGuiWithDataStructure(this.dataStructures);
    }

    @Override
    public void quit() {
        if (GuiTools.askUserToQuit(this.gui.getWindowAsComponent())) {
            this.reallyQuit();
        }
    }

    public void reallyQuit() {
        List<KanjiSet> list;
        this.saveOptions();
        if (null != this.dataStructures && !this.startupExceptionOccured && null != (list = this.dataStructures.getKanjiSets())) {
            this.saveKanjiSets();
        }
        if (null != this.gui && !this.startupExceptionOccured) {
            this.gui.saveManualVocabularyOrder();
            this.gui.quit();
        }
    }

    public void saveKanjiSets() {
        List<KanjiSet> list = this.dataStructures.getKanjiSets();
        AllKanjiSetsWriter.write(list);
    }

    public List<Vocable> collectVocablesOfAllVocabularies() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            arrayList.addAll(vocabulary.getVocables());
        }
        return arrayList;
    }

    public void setVocabularySortOrder(VocabularySortOrder vocabularySortOrder) {
        this.options.setVocabularySortOrder(vocabularySortOrder);
        this.saveOptions();
    }

    private void checksForNewVersionsAtStart() {
        this.checkingNewVersionsOnStartUp = true;
        if (this.options.isCheckNewOwnListsVersionAtStart()) {
            this.checkNewOwnListsVersion();
        } else {
            OwnListVersionsAndInterestUpdater.updateOwnListVersionsAndInterestsForNewOwnLists();
        }
        this.checkingNewVersionsOnStartUp = false;
    }

    public void checkNewProgramVersion() {
        this.gui.startLongTimeProcess("Pr\u00fcfe auf aktuellere Programmversion");
        new Thread(() -> this.checkNewProgramVersionInOwnThread()).start();
    }

    private void checkNewProgramVersionInOwnThread() {
        String string = VocabularyTrainerVersion.getOnlyVersion();
        ProgramUpdatableChecker programUpdatableChecker = new ProgramUpdatableChecker(string, this.gui.getWindowAsComponent(), this.gui.getLocation(), this.gui.getProgramImage());
        programUpdatableChecker.update();
        SwingUtilities.invokeLater(() -> this.gui.endLongTimeProcess());
    }

    public void checkNewVocabulariesVersion() {
        this.gui.startLongTimeProcess("Pr\u00fcfe auf aktuellere Version der Vokabeln");
        new Thread(() -> this.checkNewVocabulariesVersionInOwnThread()).start();
    }

    private void checkNewVocabulariesVersionInOwnThread() {
        VocablesUpdatableChecker vocablesUpdatableChecker = new VocablesUpdatableChecker(this.options.getVocabulariesPath(), this.gui);
        vocablesUpdatableChecker.check();
        SwingUtilities.invokeLater(() -> this.gui.endLongTimeProcess());
    }

    public void checkNewOwnListsVersion() {
        VocablesActualityChecker vocablesActualityChecker = new VocablesActualityChecker(this.options.getVocabulariesPath());
        vocablesActualityChecker.check();
        if (vocablesActualityChecker.isVersionOnWebserverDetermined() && vocablesActualityChecker.isActual()) {
            this.reallyCheckNewOwnListsVersion();
        } else {
            this.informAboutNoOwnListUpdateBecauseOfNewVocablesOnWebserver("Updatepr\u00fcfung der eigenen Listen");
        }
    }

    private void informAboutNoOwnListUpdateBecauseOfNewVocablesOnWebserver(String string) {
        String string2 = string + ": Neuere Vokabeln auf dem Webserver!";
        String string3 = string + " entf\u00e4llt, denn es gibt neuere Vokabeln auf dem Webserver!\n\nSolange es neuere Vokabeln gibt, macht der Downonload der Gruppen von\neigenen Listen keinen Sinn, denn wenn die Vokabeln nicht aktuell sind,\ndann werden dort sofort wieder Eintr\u00e4ge entfernt.\n\nBitte aktualisieren Sie zun\u00e4chst die Vokabeln.";
        GuiTools.informUser(this.gui.getWindowAsComponent(), string2, string3);
    }

    private void reallyCheckNewOwnListsVersion() {
        OwnListGroupsUpdater ownListGroupsUpdater = new OwnListGroupsUpdater(this.dataStructures, this.gui.getUiObjects(), this.checkingNewVersionsOnStartUp);
        ownListGroupsUpdater.update();
    }

    public void addVocableToWrongTestedVocablesList(Vocable vocable) {
        WrongTestedVocables wrongTestedVocables = this.dataStructures.getWrongTestedVocables();
        wrongTestedVocables.addVocableToWrongTestedVocablesList(vocable);
        this.gui.setCorrectForegroundColorOfVocabularyBarsLater();
        this.gui.showTranslationDirectionOnBarButtons();
    }

    public void removeVocableFromWrongTestedVocablesList(Vocable vocable) {
        WrongTestedVocables wrongTestedVocables = this.dataStructures.getWrongTestedVocables();
        wrongTestedVocables.removeVocableFromWrongTestedVocablesList(vocable);
        this.gui.setCorrectForegroundColorOfVocabularyBarsLater();
        this.gui.showTranslationDirectionOnBarButtons();
    }

    public void importGroupsOfOwnListsFromWebsite() {
        VocablesActualityChecker vocablesActualityChecker = new VocablesActualityChecker(this.options.getVocabulariesPath());
        vocablesActualityChecker.check();
        if (vocablesActualityChecker.isVersionOnWebserverDetermined() && vocablesActualityChecker.isActual()) {
            new Thread(() -> this.importGroupsOfOwnListsFromWebsiteInOwnThread()).start();
        } else {
            this.informAboutNoOwnListUpdateBecauseOfNewVocablesOnWebserver("Import von eigenen Listen");
        }
    }

    private void importGroupsOfOwnListsFromWebsiteInOwnThread() {
        GroupsOfOwnListsFromWebsiteImporter groupsOfOwnListsFromWebsiteImporter = new GroupsOfOwnListsFromWebsiteImporter(this.dataStructures, this.gui.getUiObjects());
        groupsOfOwnListsFromWebsiteImporter.importGroups();
    }

    public List<Vocable> createListOfVerbsInWoerterbuchform() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isVerbInWoerterbuchform()) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    public List<Vocable> createListOfAdjectivesInPositivePresence() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isAdjectivInPositivePresence()) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    public List<Vocable> createListOfIAdjectivesInPositivePresence() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isIAdjectivInPositivePresence()) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    public List<Vocable> createListOfNaAdjectivesInPositivePresence() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isNaAdjectivInPositivePresence()) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    public List<Vocable> createListOfNaAdjectivesPositivePresenceEndsWithI() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.isNaAdjectivInPositivePresence() || !vocable.endWithHiragana(Hiragana.I)) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    public List<Vocable> createListOfIruEruExceptionVerbsInWoerterbuchform() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        for (Vocabulary vocabulary : list) {
            for (Vocable vocable : vocabulary.getVocables()) {
                String string;
                if (!vocable.isVerbInWoerterbuchform() || !vocable.hasIruEruEnd() || !(string = vocable.getComment()).contains("Godan verb")) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithOnLesung(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!CollectionsHelper.containedInAnyListElement(string, kanji.getOnLesungen())) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithKunLesung(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!CollectionsHelper.containedInAnyListElement(string, kanji.getKunLesungen())) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithAnyLesung(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!CollectionsHelper.containedInAnyListElement(string, kanji.getOnLesungen()) && !CollectionsHelper.containedInAnyListElement(string, kanji.getKunLesungen())) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithGermanMeaning(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!CollectionsHelper.containedInAnyListElement(string, kanji.getGermanMeanings())) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    public List<Kanji> findAllKanjiWithAny(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            if (!CollectionsHelper.containedInAnyListElement(string, kanji.getOnLesungen()) && !CollectionsHelper.containedInAnyListElement(string, kanji.getKunLesungen()) && !CollectionsHelper.containedInAnyListElement(string, kanji.getGermanMeanings()) && !kanji.getCharacter().equals(string)) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    public FumikoDataStructures getDataStructures() {
        return this.dataStructures;
    }
}

