/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.bars;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.move.VerticalMoveButtons;
import de.duehl.swing.ui.move.data.MovingGui;
import de.duehl.swing.ui.move.data.VerticalMoveButtonsUser;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.success.VocabularyTestSuccesssCalculator;
import de.duehl.vocabulary.japanese.logic.test.VocableListTesterLogic;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.components.bars.data.VocabularyBarShownButtonsType;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.lister.VocabularyListerDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet.VocableSheetsCreator;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.sheet.VocabularySheetDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.single.SingleVocableVocabularyViewerDialog;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VocabularyBar
implements VerticalMoveButtonsUser {
    private static final String TEST_VIEW_LIST_SHEET_BUTTONS_NAME = "TEST-VIEW-LIST-SHEET-BUTTONS";
    private static final String MOVE_UP_AND_DOWN_BUTTONS_NAME = "MOVE-UP-AND-DOWN-BUTTONS";
    private static final String OWN_LISTS_EXTRA_BUTTONS_NAME = "OWN-LISTS-EXTRA-BUTTONS";
    private final Vocabulary vocabulary;
    private final VocabularyTrainerLogic logic;
    private final VocabularyTrainerGui gui;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final MovingGui<VocabularyBar> movingGui;
    private final JPanel panel;
    private final JPanel testViewListSheetButtonsPanel;
    private final JPanel switchingContentButtonPanel;
    private final CardLayout cardLayout;
    private final VerticalMoveButtons moveButtons;
    private final JPanel ownListsExtraButtonsPanel;
    private final JCheckBox selectionCheckBox;
    private final JLabel vocabularyLabel;
    private String perhapsShortenedVocabularyDescription;
    private final JPanel vocabularyAndPercentPanel;
    private final JLabel successPercentLabel;
    private VocabularyBarShownButtonsType shownButtonsType;

    public VocabularyBar(Vocabulary vocabulary, VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, MovingGui<VocabularyBar> movingGui) {
        this.vocabulary = vocabulary;
        this.logic = vocabularyTrainerLogic;
        this.gui = vocabularyTrainerGui;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.movingGui = movingGui;
        this.panel = new JPanel();
        this.moveButtons = new VerticalMoveButtons(this);
        this.selectionCheckBox = new JCheckBox();
        this.vocabularyLabel = new JLabel();
        this.successPercentLabel = new JLabel();
        this.testViewListSheetButtonsPanel = new JPanel();
        this.switchingContentButtonPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.perhapsShortenedVocabularyDescription = this.buildPerhapsShortenedVocabularyDescription();
        this.vocabularyAndPercentPanel = new JPanel();
        this.ownListsExtraButtonsPanel = new JPanel();
        this.shownButtonsType = VocabularyBarShownButtonsType.TEST_VIEW_LIST_SHEET_BUTTONS;
        this.setLabelText();
        this.initSuccessPercentLabel();
        this.initViewTestListSheet();
        this.initOwnListsExtraButtons();
        this.initSwitchingContentButtonPanel();
        this.initOtherElements();
        this.fillPanel();
        this.setCorrectForegroundColor();
        this.fillVocabularyAndPercentPanel();
    }

    private void initSuccessPercentLabel() {
        GuiTools.setMonospacedFont(this.successPercentLabel);
        this.successPercentLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    private String buildPerhapsShortenedVocabularyDescription() {
        Object object = this.vocabulary.getDescription();
        Options options = this.dataStructures.getOptions();
        if (options.isHideStartOfVocabularyDescription()) {
            object = VocabularyTools.hideStartOfVocabularyDescription((String)object, options.isHideLessStartOfVocabularyDescriptionForVhs());
        }
        int n = options.getNumberOfCharsInVocableBarTitleShown();
        if (((String)object).length() > n) {
            object = ((String)object).substring(0, n - 4) + " ...";
        }
        return object;
    }

    private void setLabelText() {
        this.vocabularyLabel.setText(this.perhapsShortenedVocabularyDescription);
    }

    private void initViewTestListSheet() {
        this.testViewListSheetButtonsPanel.setLayout(new FlowLayout());
        this.populateViewTestListSheet();
    }

    private void populateViewTestListSheet() {
        this.testViewListSheetButtonsPanel.removeAll();
        this.testViewListSheetButtonsPanel.add(this.createTestButton());
        this.testViewListSheetButtonsPanel.add(this.createViewButton());
        this.testViewListSheetButtonsPanel.add(this.createListButton());
        this.testViewListSheetButtonsPanel.add(this.createSheetButton());
        this.testViewListSheetButtonsPanel.repaint();
        this.testViewListSheetButtonsPanel.validate();
        this.testViewListSheetButtonsPanel.invalidate();
    }

    private Component createViewButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("VIEW_VOCABULARY", actionEvent -> this.viewVocabulary(), "Vokabeln anzeigen");
        if (this.vocabulary.getVocables().isEmpty()) {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    private void viewVocabulary() {
        SingleVocableVocabularyViewerDialog singleVocableVocabularyViewerDialog = new SingleVocableVocabularyViewerDialog(this.vocabulary.getVocables(), "Gesamtanzeige '" + this.vocabulary.getDescription() + "'", this.dataStructures, this.uiObjects);
        singleVocableVocabularyViewerDialog.setVisible(true);
        this.gui.setMessageLater("Das Vokabular \"" + this.vocabulary.getDescription() + "\" wurde in Einzeldarstellung angezeigt.");
    }

    private Component createTestButton() {
        String string;
        Options options = this.dataStructures.getOptions();
        TranslationDirection translationDirection = options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            string = "TEST_VOCABULARY_JAPANESE_TO_GERMAN";
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            string = "TEST_VOCABULARY_GERMAN_TO_JAPANESE";
        } else {
            throw new RuntimeException("Unbekannte TranslationDirection " + translationDirection + ".");
        }
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton(string, actionEvent -> this.testVocabulary(), "Vokabeln abfragen");
        if (this.vocabulary.getVocables().isEmpty()) {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    private void testVocabulary() {
        VocableListTesterLogic vocableListTesterLogic = new VocableListTesterLogic(this.vocabulary.getVocables(), "Gesamtabfrage '" + this.vocabulary.getDescription() + "'", this.logic, this.dataStructures, this.uiObjects);
        vocableListTesterLogic.test();
        this.setCorrectForegroundColor();
        this.gui.setMessageLater("Das Vokabular \"" + this.vocabulary.getDescription() + "\" wurde abgefragt.");
    }

    private Component createListButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("SHOW_VOCABULARY_LIST", actionEvent -> this.listVocabulary(), "Vokabeln als Liste anzeigen");
        if (this.vocabulary.getVocables().isEmpty()) {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    private void listVocabulary() {
        VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(this.vocabulary.getVocables(), this.vocabulary.getDescription(), this.dataStructures, this.uiObjects, this.uiObjects.getGuiLocation(), this.gui);
        vocabularyListerDialog.setVisible(true);
        this.gui.setMessageLater("Das Vokabular \"" + this.vocabulary.getDescription() + "\" wurde als Liste angezeigt.");
    }

    private Component createSheetButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("SHOW_VOCABULARY_SHEET", actionEvent -> this.listVocabularyAsSheet(), "Vokabeln auf einem Blatt anzeigen");
        if (this.vocabulary.getVocables().isEmpty()) {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    private void listVocabularyAsSheet() {
        this.gui.startLongTimeProcess("\u00d6ffne Blattdarstellung mit " + NumberString.taupu(this.vocabulary.getVocables().size()) + " Vokabeln");
        new Thread(() -> this.listVocabularyAsSheetInOwnThread()).start();
    }

    private void listVocabularyAsSheetInOwnThread() {
        try {
            this.tryToListVocabularyAsSheetInOwnThread();
        }
        catch (Exception exception) {
            GuiTools.informUser("Hier ging etwas schief", "Bei der Erzeugng der Panel f\u00fcr die Blattdarstellung gab es ein Problem.");
            this.gui.endLongTimeProcess();
        }
    }

    private void tryToListVocabularyAsSheetInOwnThread() {
        VocableSheetsCreator vocableSheetsCreator = new VocableSheetsCreator(this.vocabulary.getVocables(), this.dataStructures, this.uiObjects, (list, list2) -> this.listVocabularyAsSheetInEdt(list, list2), this.uiObjects.getGuiLocation());
        vocableSheetsCreator.create();
    }

    private void listVocabularyAsSheetInEdt(List<Vocable> list, List<Component> list2) {
        try {
            this.tryToListVocabularyAsSheetInEdt(list, list2);
        }
        catch (Exception exception) {
            GuiTools.informUser("Hier ging etwas schief", "Bei der Anzeige der Blattdarstellung gab es ein Problem.");
            this.gui.endLongTimeProcess();
        }
    }

    private void tryToListVocabularyAsSheetInEdt(List<Vocable> list, List<Component> list2) {
        VocabularySheetDialog vocabularySheetDialog = new VocabularySheetDialog(list, list2, this.vocabulary.getDescription(), this.dataStructures, this.uiObjects, this.uiObjects.getInformer(), this.uiObjects.getGuiLocation());
        vocabularySheetDialog.setVisible(true);
        vocabularySheetDialog.requestFocus();
        this.gui.endLongTimeProcess();
        this.gui.setMessageLater("Das Vokabular \"" + this.vocabulary.getDescription() + "\" wurde als Blatt angezeigt.");
    }

    @Override
    public boolean canMoveButtonsUserMoveUp() {
        return this.movingGui.canBarMoveUp(this);
    }

    @Override
    public boolean canMoveButtonsUserMoveDown() {
        return this.movingGui.canBarMoveDown(this);
    }

    @Override
    public void moveMoveButtonsUserToFirst() {
        this.movingGui.moveBarToFirst(this);
    }

    @Override
    public void moveMoveButtonsUserUp() {
        this.movingGui.moveBarUp(this);
    }

    @Override
    public void moveMoveButtonsUserDown() {
        this.movingGui.moveBarDown(this);
    }

    @Override
    public void moveMoveButtonsUserToLast() {
        this.movingGui.moveBarToLast(this);
    }

    public void setUpAndDownButtonColorsAndEnabled() {
        this.moveButtons.setUpAndDownButtonColorsAndEnabled();
    }

    private void initOwnListsExtraButtons() {
        this.ownListsExtraButtonsPanel.setLayout(new GridLayout(1, 0, 2, 2));
        this.ownListsExtraButtonsPanel.add(this.createDeleteButton());
        this.ownListsExtraButtonsPanel.add(this.createEditButton());
        this.ownListsExtraButtonsPanel.add(this.createExportButton());
        this.ownListsExtraButtonsPanel.add(new JLabel());
    }

    private Component createDeleteButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("DELETE_OWN_LIST", actionEvent -> this.gui.deleteOwnList(this.getVocabularyAsOwnList()), "Vokabelliste l\u00f6schen");
        jButton.setForeground(Color.RED);
        return jButton;
    }

    private Component createEditButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("EDIT_OWN_LIST", actionEvent -> this.gui.editOwnList(this.getVocabularyAsOwnList()), "Vokabelliste bearbeiten");
        return jButton;
    }

    private Component createExportButton() {
        JButton jButton = VocabularyTrainerUiTools.createPicturedButton("EXPORT_OWN_LIST", actionEvent -> this.gui.exportListOwnList(this.getVocabularyAsOwnList()), "Vokabelliste exportieren");
        return jButton;
    }

    private void initSwitchingContentButtonPanel() {
        this.switchingContentButtonPanel.setLayout(this.cardLayout);
        this.switchingContentButtonPanel.add((Component)this.testViewListSheetButtonsPanel, TEST_VIEW_LIST_SHEET_BUTTONS_NAME);
        this.switchingContentButtonPanel.add((Component)this.moveButtons.getPanel(), MOVE_UP_AND_DOWN_BUTTONS_NAME);
        this.switchingContentButtonPanel.add((Component)this.ownListsExtraButtonsPanel, OWN_LISTS_EXTRA_BUTTONS_NAME);
    }

    private void initOtherElements() {
        GuiTools.biggerFont(this.vocabularyLabel, 7);
        this.vocabularyLabel.setHorizontalAlignment(0);
    }

    private void fillPanel() {
        this.panel.setLayout(new BorderLayout());
        GuiTools.createTitle(this.panel);
        this.panel.add((Component)this.vocabularyAndPercentPanel, "Center");
        this.panel.add(this.createButtonBar(), "East");
    }

    private void fillVocabularyAndPercentPanel() {
        this.vocabularyAndPercentPanel.setLayout(new BorderLayout());
        this.vocabularyAndPercentPanel.removeAll();
        this.vocabularyAndPercentPanel.add((Component)this.vocabularyLabel, "Center");
        Options options = this.dataStructures.getOptions();
        if (options.isShowSuccessPercentInVocabularyBar()) {
            this.vocabularyAndPercentPanel.add(this.createSuccessPercentLabelPart(), "East");
        }
    }

    private Component createSuccessPercentLabelPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.successPercentLabel, "Center");
        return jPanel;
    }

    private Component createButtonBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.switchingContentButtonPanel, "Center");
        jPanel.add((Component)this.selectionCheckBox, "East");
        return jPanel;
    }

    public void setCorrectForegroundColor() {
        VocabularyTestSuccesssCalculator vocabularyTestSuccesssCalculator = new VocabularyTestSuccesssCalculator(this.vocabulary, this.dataStructures);
        vocabularyTestSuccesssCalculator.calculate();
        Color color = vocabularyTestSuccesssCalculator.getForegroundColor();
        this.vocabularyLabel.setForeground(color);
        this.vocabularyLabel.repaint();
        this.vocabularyLabel.invalidate();
        this.vocabularyLabel.validate();
        this.successPercentLabel.setText(vocabularyTestSuccesssCalculator.getPercentText());
    }

    public void setCorrectText() {
        this.perhapsShortenedVocabularyDescription = this.buildPerhapsShortenedVocabularyDescription();
        this.setLabelText();
        this.vocabularyLabel.repaint();
        this.vocabularyLabel.invalidate();
        this.vocabularyLabel.validate();
    }

    public void showOrHidePercent() {
        this.fillVocabularyAndPercentPanel();
    }

    public Component getPanel() {
        return this.panel;
    }

    public boolean isSelected() {
        return this.selectionCheckBox.isSelected();
    }

    public void setSelected(boolean bl) {
        this.selectionCheckBox.setSelected(bl);
    }

    public Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    public String getVocabularyCategory() {
        return this.vocabulary.getCategory();
    }

    public String getVocabularySubCategory() {
        return this.vocabulary.getSubCategory();
    }

    public void showTranslationDirectionOnBarButtons() {
        this.populateViewTestListSheet();
    }

    public OwnList getVocabularyAsOwnList() {
        Vocabulary vocabulary = this.vocabulary;
        if (vocabulary instanceof OwnList) {
            OwnList ownList = (OwnList)vocabulary;
            return ownList;
        }
        throw new RuntimeException("Es wird versucht, ein Vokabular als eigene Liste zur\u00fcckzugeben, welches keine eigene Liste ist.");
    }

    public void showOrHideIndividualVocabularySortModeMoveButtons() {
        VocabularyBarShownButtonsType vocabularyBarShownButtonsType = VocabularyBarShownButtonsType.MOVE_UP_AND_DOWN_BUTTONS;
        this.changeSwitchingContentButtons(vocabularyBarShownButtonsType);
    }

    public void toggleShowOwnListButtons() {
        VocabularyBarShownButtonsType vocabularyBarShownButtonsType = VocabularyBarShownButtonsType.OWN_LISTS_EXTRA_BUTTONS;
        this.changeSwitchingContentButtons(vocabularyBarShownButtonsType);
    }

    private void changeSwitchingContentButtons(VocabularyBarShownButtonsType vocabularyBarShownButtonsType) {
        if (this.shownButtonsType == vocabularyBarShownButtonsType) {
            this.showTestViewListSheetButtons();
        } else if (vocabularyBarShownButtonsType == VocabularyBarShownButtonsType.MOVE_UP_AND_DOWN_BUTTONS) {
            this.showMoveUpAndDownButtons();
        } else if (vocabularyBarShownButtonsType == VocabularyBarShownButtonsType.OWN_LISTS_EXTRA_BUTTONS) {
            this.showOwnListExtraButtons();
        } else {
            throw new RuntimeException("Logikfehler.");
        }
    }

    public void showTestViewListSheetButtons() {
        this.shownButtonsType = VocabularyBarShownButtonsType.TEST_VIEW_LIST_SHEET_BUTTONS;
        String string = TEST_VIEW_LIST_SHEET_BUTTONS_NAME;
        this.switchCardLayout(string);
    }

    private void showMoveUpAndDownButtons() {
        this.shownButtonsType = VocabularyBarShownButtonsType.MOVE_UP_AND_DOWN_BUTTONS;
        String string = MOVE_UP_AND_DOWN_BUTTONS_NAME;
        this.switchCardLayout(string);
    }

    public void showOwnListExtraButtons() {
        this.shownButtonsType = VocabularyBarShownButtonsType.OWN_LISTS_EXTRA_BUTTONS;
        String string = OWN_LISTS_EXTRA_BUTTONS_NAME;
        this.switchCardLayout(string);
    }

    private void switchCardLayout(String string) {
        this.cardLayout.show(this.switchingContentButtonPanel, string);
        this.panel.repaint();
    }

    public boolean isOwnListsBar() {
        return this.vocabulary instanceof OwnList;
    }
}

