/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.KanjiForTestSelectionMethod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class KanjiTestParameterChooser
extends ModalDialogBase {
    private static final int MIN_WIDTH = 500;
    private final List<KanjiSet> kanjiSets;
    private final Options options;
    private final List<Kanji> notTenTimesGoodTestedKanjiList;
    private final JComboBox<String> kanjiSetSelectionComboBox;
    private final Map<String, List<Kanji>> kanjiListByComboBoxText;
    private boolean applied;
    private final JCheckBox useOriginalKanjiOrderCheckBox;
    private final JRadioButton fiveKanjiRadioButton;
    private final JRadioButton tenKanjiRadioButton;
    private final JRadioButton fifteenKanjiRadioButton;
    private final JRadioButton twenytKanjiRadioButton;
    private final JRadioButton thirtyKanjiRadioButton;
    private final JRadioButton fiftyKanjiRadioButton;
    private final JRadioButton allKanjiRadioButton;
    private final JRadioButton notTenTimesGoodTestedKanjiRadioButton;
    private final JRadioButton lastFiftyKanjiRadioButton;
    private final JRadioButton lastThirtyKanjiRadioButton;
    private final JRadioButton lastTwentyKanjiRadioButton;
    private final JRadioButton lastFifteenKanjiRadioButton;
    private final JRadioButton lastTenKanjiRadioButton;
    private final JRadioButton lastFiveKanjiRadioButton;
    private final JRadioButton oldestTestedFiftyKanjiRadioButton;
    private final JRadioButton oldestTestedThirtyKanjiRadioButton;
    private final JRadioButton oldestTestedTwentyKanjiRadioButton;
    private final JRadioButton oldestTestedFifteenKanjiRadioButton;
    private final JRadioButton oldestTestedTenKanjiRadioButton;
    private final JRadioButton oldestTestedFiveKanjiRadioButton;
    private final JRadioButton mostSeldomTestedFiftyKanjiRadioButton;
    private final JRadioButton mostSeldomTestedThirtyKanjiRadioButton;
    private final JRadioButton mostSeldomTestedTwentyKanjiRadioButton;
    private final JRadioButton mostSeldomTestedFifteenKanjiRadioButton;
    private final JRadioButton mostSeldomTestedTenKanjiRadioButton;
    private final JRadioButton mostSeldomTestedFiveKanjiRadioButton;
    private final JCheckBox germanMeaningCaseSensitivityCheckBox;
    private final JCheckBox onLesungCaseSensitivityCheckBox;
    private final JCheckBox kunLesungCaseSensitivityCheckBox;
    private final JButton okButton;
    private int numberOfKanjiToTest;
    private boolean useOriginalKanjiOrder;
    private KanjiForTestSelectionMethod selectionMethod;
    private boolean germanMeaningCaseSensitivity;
    private boolean onLesungCaseSensitivity;
    private boolean kunLesungCaseSensitivity;
    private List<Kanji> kanjiList;

    public KanjiTestParameterChooser(List<KanjiSet> list, Options options, List<Kanji> list2, Point point, Image image) {
        super(point, image, "Die Parameter f\u00fcr den Kanji-Test ausw\u00e4hlen");
        this.kanjiSets = list;
        this.options = options;
        this.notTenTimesGoodTestedKanjiList = list2;
        this.kanjiSetSelectionComboBox = new JComboBox();
        this.kanjiListByComboBoxText = new HashMap<String, List<Kanji>>();
        this.useOriginalKanjiOrderCheckBox = new JCheckBox("in Originalreihenfolge");
        this.fiveKanjiRadioButton = new JRadioButton("5 Kanji");
        this.tenKanjiRadioButton = new JRadioButton("10 Kanji");
        this.fifteenKanjiRadioButton = new JRadioButton("15 Kanji");
        this.twenytKanjiRadioButton = new JRadioButton("20 Kanji");
        this.thirtyKanjiRadioButton = new JRadioButton("30 Kanji");
        this.fiftyKanjiRadioButton = new JRadioButton("50 Kanji");
        this.allKanjiRadioButton = new JRadioButton("Alle Kanji (" + NumberString.taupu(Kanji.getNumberOfKnownKanji()) + ")");
        this.notTenTimesGoodTestedKanjiRadioButton = new JRadioButton("nicht zuletzt zehn mal richtig abgefragte Kanji");
        this.lastFiftyKanjiRadioButton = new JRadioButton("die letzten 50 Kanji");
        this.lastThirtyKanjiRadioButton = new JRadioButton("die letzten 30 Kanji");
        this.lastTwentyKanjiRadioButton = new JRadioButton("die letzten 20 Kanji");
        this.lastFifteenKanjiRadioButton = new JRadioButton("die letzten 15 Kanji");
        this.lastTenKanjiRadioButton = new JRadioButton("die letzten 10 Kanji");
        this.lastFiveKanjiRadioButton = new JRadioButton("die letzten 5 Kanji");
        this.oldestTestedFiftyKanjiRadioButton = new JRadioButton("die 50 am l\u00e4ngsten nicht mehr abgefragten Kanji");
        this.oldestTestedThirtyKanjiRadioButton = new JRadioButton("die 30 am l\u00e4ngsten nicht mehr abgefragten Kanji");
        this.oldestTestedTwentyKanjiRadioButton = new JRadioButton("die 20 am l\u00e4ngsten nicht mehr abgefragten Kanji");
        this.oldestTestedFifteenKanjiRadioButton = new JRadioButton("die 15 am l\u00e4ngsten nicht mehr abgefragten Kanji");
        this.oldestTestedTenKanjiRadioButton = new JRadioButton("die 10 am l\u00e4ngsten nicht mehr abgefragten Kanji");
        this.oldestTestedFiveKanjiRadioButton = new JRadioButton("die 5 am l\u00e4ngsten nicht mehr abgefragten Kanji");
        this.mostSeldomTestedFiftyKanjiRadioButton = new JRadioButton("die 50 am seltensten abgefragten Kanji");
        this.mostSeldomTestedThirtyKanjiRadioButton = new JRadioButton("die 30 am seltensten abgefragten Kanji");
        this.mostSeldomTestedTwentyKanjiRadioButton = new JRadioButton("die 20 am seltensten abgefragten Kanji");
        this.mostSeldomTestedFifteenKanjiRadioButton = new JRadioButton("die 15 am seltensten abgefragten Kanji");
        this.mostSeldomTestedTenKanjiRadioButton = new JRadioButton("die 10 am seltensten abgefragten Kanji");
        this.mostSeldomTestedFiveKanjiRadioButton = new JRadioButton("die 5 am seltensten abgefragten Kanji");
        this.germanMeaningCaseSensitivityCheckBox = new JCheckBox("Bei der \u00dcberpr\u00fcfung der deutschen Bedeutung auf Gro\u00df-/Kleinschreibung achten.");
        this.onLesungCaseSensitivityCheckBox = new JCheckBox("Bei der \u00dcberpr\u00fcfung der ON-Lesung auf Gro\u00df-/Kleinschreibung achten.");
        this.kunLesungCaseSensitivityCheckBox = new JCheckBox("Bei der \u00dcberpr\u00fcfung der kun-Lesung auf Gro\u00df-/Kleinschreibung achten.");
        this.okButton = new JButton();
        this.selectionMethod = KanjiForTestSelectionMethod.UNKNOWN;
        this.applied = false;
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.initComboBox();
        this.fillComboBox();
        this.addComboBoxActionListener();
        this.initRadioButtons();
        this.initCheckBoxes();
    }

    private void initComboBox() {
        this.kanjiSetSelectionComboBox.setAlignmentX(0.0f);
        this.kanjiSetSelectionComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.kanjiSetSelectionComboBox.getRenderer())).setHorizontalAlignment(0);
    }

    private void fillComboBox() {
        this.kanjiSetSelectionComboBox.removeAllItems();
        String string = "Alle bekannten Kanji";
        List<Kanji> list = Kanji.getAllKanjiAsList();
        this.kanjiListByComboBoxText.put(string, list);
        this.kanjiSetSelectionComboBox.addItem(string);
        for (KanjiSet kanjiSet : this.kanjiSets) {
            String string2 = kanjiSet.getName();
            String string3 = "Menge '" + string2 + "'";
            List<Kanji> list2 = kanjiSet.getSet();
            this.kanjiListByComboBoxText.put(string3, list2);
            this.kanjiSetSelectionComboBox.addItem(string3);
        }
        String string4 = this.options.getLastSelectedKanjiSetTextInCombobox();
        if (this.kanjiListByComboBoxText.containsKey(string4)) {
            this.kanjiSetSelectionComboBox.setSelectedItem(string4);
        } else {
            this.kanjiSetSelectionComboBox.setSelectedItem(string);
        }
        this.comboboxSelectionChanged();
    }

    private void addComboBoxActionListener() {
        this.kanjiSetSelectionComboBox.addActionListener(actionEvent -> this.comboboxSelectionChanged());
    }

    private void comboboxSelectionChanged() {
        String string = (String)this.kanjiSetSelectionComboBox.getSelectedItem();
        if (!this.kanjiListByComboBoxText.containsKey(string)) {
            this.quit();
            throw new RuntimeException("Der Text aus der Combobox '" + string + "' ist im Verzeichnis der Kanjilisten nach dem Text nicht bekannt.");
        }
        List<Kanji> list = this.kanjiListByComboBoxText.get(string);
        int n = list.size();
        this.allKanjiRadioButton.setText("Alle Kanji (" + NumberString.taupu(n) + ")");
        int n2 = this.notTenTimesGoodTestedKanjiList.size();
        this.notTenTimesGoodTestedKanjiRadioButton.setText("nicht zuletzt zehn mal richtig abgefragte Kanji (" + n2 + ")");
        this.notTenTimesGoodTestedKanjiRadioButton.setEnabled(!this.notTenTimesGoodTestedKanjiList.isEmpty());
        this.handleRadioButton(this.fiveKanjiRadioButton, 5, n);
        this.handleRadioButton(this.tenKanjiRadioButton, 10, n);
        this.handleRadioButton(this.fifteenKanjiRadioButton, 15, n);
        this.handleRadioButton(this.twenytKanjiRadioButton, 20, n);
        this.handleRadioButton(this.thirtyKanjiRadioButton, 30, n);
        this.handleRadioButton(this.fiftyKanjiRadioButton, 50, n);
        this.handleRadioButton(this.lastFiftyKanjiRadioButton, 50, n);
        this.handleRadioButton(this.lastThirtyKanjiRadioButton, 30, n);
        this.handleRadioButton(this.lastTwentyKanjiRadioButton, 20, n);
        this.handleRadioButton(this.lastFifteenKanjiRadioButton, 15, n);
        this.handleRadioButton(this.lastTenKanjiRadioButton, 10, n);
        this.handleRadioButton(this.lastFiveKanjiRadioButton, 5, n);
        this.handleRadioButton(this.oldestTestedFiftyKanjiRadioButton, 50, n);
        this.handleRadioButton(this.oldestTestedThirtyKanjiRadioButton, 30, n);
        this.handleRadioButton(this.oldestTestedTwentyKanjiRadioButton, 20, n);
        this.handleRadioButton(this.oldestTestedFifteenKanjiRadioButton, 15, n);
        this.handleRadioButton(this.oldestTestedTenKanjiRadioButton, 10, n);
        this.handleRadioButton(this.oldestTestedFiveKanjiRadioButton, 5, n);
        this.handleRadioButton(this.mostSeldomTestedFiftyKanjiRadioButton, 50, n);
        this.handleRadioButton(this.mostSeldomTestedThirtyKanjiRadioButton, 30, n);
        this.handleRadioButton(this.mostSeldomTestedTwentyKanjiRadioButton, 20, n);
        this.handleRadioButton(this.mostSeldomTestedFifteenKanjiRadioButton, 15, n);
        this.handleRadioButton(this.mostSeldomTestedTenKanjiRadioButton, 10, n);
        this.handleRadioButton(this.mostSeldomTestedFiveKanjiRadioButton, 5, n);
    }

    private void handleRadioButton(JRadioButton jRadioButton, int n, int n2) {
        jRadioButton.setEnabled(n2 >= n);
        if (n2 < n && jRadioButton.isSelected()) {
            jRadioButton.setSelected(false);
        }
    }

    private void initRadioButtons() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fiveKanjiRadioButton);
        buttonGroup.add(this.tenKanjiRadioButton);
        buttonGroup.add(this.fifteenKanjiRadioButton);
        buttonGroup.add(this.twenytKanjiRadioButton);
        buttonGroup.add(this.thirtyKanjiRadioButton);
        buttonGroup.add(this.fiftyKanjiRadioButton);
        buttonGroup.add(this.allKanjiRadioButton);
        buttonGroup.add(this.notTenTimesGoodTestedKanjiRadioButton);
        buttonGroup.add(this.lastFiftyKanjiRadioButton);
        buttonGroup.add(this.lastThirtyKanjiRadioButton);
        buttonGroup.add(this.lastTwentyKanjiRadioButton);
        buttonGroup.add(this.lastFifteenKanjiRadioButton);
        buttonGroup.add(this.lastTenKanjiRadioButton);
        buttonGroup.add(this.lastFiveKanjiRadioButton);
        buttonGroup.add(this.oldestTestedFiftyKanjiRadioButton);
        buttonGroup.add(this.oldestTestedThirtyKanjiRadioButton);
        buttonGroup.add(this.oldestTestedTwentyKanjiRadioButton);
        buttonGroup.add(this.oldestTestedFifteenKanjiRadioButton);
        buttonGroup.add(this.oldestTestedTenKanjiRadioButton);
        buttonGroup.add(this.oldestTestedFiveKanjiRadioButton);
        buttonGroup.add(this.mostSeldomTestedFiftyKanjiRadioButton);
        buttonGroup.add(this.mostSeldomTestedThirtyKanjiRadioButton);
        buttonGroup.add(this.mostSeldomTestedTwentyKanjiRadioButton);
        buttonGroup.add(this.mostSeldomTestedFifteenKanjiRadioButton);
        buttonGroup.add(this.mostSeldomTestedTenKanjiRadioButton);
        buttonGroup.add(this.mostSeldomTestedFiveKanjiRadioButton);
        this.allKanjiRadioButton.setSelected(true);
    }

    private void initCheckBoxes() {
        this.useOriginalKanjiOrderCheckBox.setSelected(false);
        this.germanMeaningCaseSensitivityCheckBox.setSelected(false);
        this.onLesungCaseSensitivityCheckBox.setSelected(false);
        this.kunLesungCaseSensitivityCheckBox.setSelected(false);
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        SwingUtilities.invokeLater(() -> this.okButton.requestFocus());
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createKanjiSetSelectionPart(), "North");
        jPanel.add(this.createNumberOfKanjiPart(), "Center");
        jPanel.add(this.createSortKanjiAndCaseSensitivityPart(), "South");
        return jPanel;
    }

    private Component createKanjiSetSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Teilmenge der abzufragenden Kanji", jPanel);
        jPanel.add(this.kanjiSetSelectionComboBox, "Center");
        return jPanel;
    }

    private Component createNumberOfKanjiPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createNumberOfRandomSelectedKanjiPart());
        jPanel.add(this.createNumberOfLastXKanjiPart());
        jPanel.add(this.createNumberOfOldestTestedKanjiPart());
        jPanel.add(this.createNumberOfMostSeldomTestedKanjiPart());
        jPanel.add(this.createNumberOfAllKanjiPart());
        jPanel.add(this.createNumberOfNotTenTimesGoodTestedKanjiPart());
        jPanel.add(this.createDummyMinWidthLabelPart());
        return jPanel;
    }

    private Component createNumberOfRandomSelectedKanjiPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("F\u00fcr die Abfrage der Kanji die folgende Anzahl zuf\u00e4llig ausw\u00e4lhen", jPanel);
        jPanel.add(this.fiveKanjiRadioButton);
        jPanel.add(this.tenKanjiRadioButton);
        jPanel.add(this.fifteenKanjiRadioButton);
        jPanel.add(this.twenytKanjiRadioButton);
        jPanel.add(this.thirtyKanjiRadioButton);
        jPanel.add(this.fiftyKanjiRadioButton);
        return jPanel;
    }

    private Component createNumberOfLastXKanjiPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("F\u00fcr die Abfrage der Kanji die folgende Anzahl der zuletzt hinzugef\u00fcgten ausw\u00e4lhen", jPanel);
        jPanel.add(this.lastFiftyKanjiRadioButton);
        jPanel.add(this.lastThirtyKanjiRadioButton);
        jPanel.add(this.lastTwentyKanjiRadioButton);
        jPanel.add(this.lastFifteenKanjiRadioButton);
        jPanel.add(this.lastTenKanjiRadioButton);
        jPanel.add(this.lastFiveKanjiRadioButton);
        return jPanel;
    }

    private Component createNumberOfOldestTestedKanjiPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("F\u00fcr die Abfrage der Kanji die folgende Anzahl der am l\u00e4ngsten nicht mehr abgefragten Kanji ausw\u00e4lhen", jPanel);
        jPanel.add(this.oldestTestedFiftyKanjiRadioButton);
        jPanel.add(this.oldestTestedThirtyKanjiRadioButton);
        jPanel.add(this.oldestTestedTwentyKanjiRadioButton);
        jPanel.add(this.oldestTestedFifteenKanjiRadioButton);
        jPanel.add(this.oldestTestedTenKanjiRadioButton);
        jPanel.add(this.oldestTestedFiveKanjiRadioButton);
        return jPanel;
    }

    private Component createNumberOfMostSeldomTestedKanjiPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("F\u00fcr die Abfrage der Kanji die folgende Anzahl der am seltensten abgefragten Kanji ausw\u00e4lhen", jPanel);
        jPanel.add(this.mostSeldomTestedFiftyKanjiRadioButton);
        jPanel.add(this.mostSeldomTestedThirtyKanjiRadioButton);
        jPanel.add(this.mostSeldomTestedTwentyKanjiRadioButton);
        jPanel.add(this.mostSeldomTestedFifteenKanjiRadioButton);
        jPanel.add(this.mostSeldomTestedTenKanjiRadioButton);
        jPanel.add(this.mostSeldomTestedFiveKanjiRadioButton);
        return jPanel;
    }

    private Component createNumberOfAllKanjiPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("Alle Kanji abfragen", jPanel);
        jPanel.add(this.allKanjiRadioButton);
        return jPanel;
    }

    private Component createNumberOfNotTenTimesGoodTestedKanjiPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("Nicht zehn mal richtig beantwortete Kanji abfragen", jPanel);
        jPanel.add(this.notTenTimesGoodTestedKanjiRadioButton);
        return jPanel;
    }

    private Component createDummyMinWidthLabelPart() {
        JLabel jLabel = new JLabel("");
        jLabel.setPreferredSize(new Dimension(500, 0));
        return jLabel;
    }

    private Component createSortKanjiAndCaseSensitivityPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createSortKanjiPart());
        jPanel.add(this.createCaseSensitivityPart());
        return jPanel;
    }

    private Component createSortKanjiPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Sortierung", jPanel);
        jPanel.add((Component)this.useOriginalKanjiOrderCheckBox, "Center");
        return jPanel;
    }

    private Component createCaseSensitivityPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createTitle("Gro\u00df-/Kleinschreibung", jPanel);
        jPanel.add(this.germanMeaningCaseSensitivityCheckBox);
        jPanel.add(this.onLesungCaseSensitivityCheckBox);
        jPanel.add(this.kunLesungCaseSensitivityCheckBox);
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private Component createOkButton() {
        this.okButton.setText("   Abfrage starten   ");
        GuiTools.biggerFont(this.okButton, 5);
        this.okButton.addActionListener(actionEvent -> this.apply());
        return this.okButton;
    }

    private void apply() {
        String string = (String)this.kanjiSetSelectionComboBox.getSelectedItem();
        if (!this.kanjiListByComboBoxText.containsKey(string)) {
            this.quit();
            throw new RuntimeException("Der Text aus der Combobox '" + string + "' ist im Verzeichnis der Kanjilisten nach dem Text nicht bekannt.");
        }
        this.kanjiList = this.kanjiListByComboBoxText.get(string);
        this.options.setLastSelectedKanjiSetTextInCombobox(string);
        if (this.fiveKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 5;
            this.selectionMethod = KanjiForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.tenKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 10;
            this.selectionMethod = KanjiForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.fifteenKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 15;
            this.selectionMethod = KanjiForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.twenytKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 20;
            this.selectionMethod = KanjiForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.thirtyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 30;
            this.selectionMethod = KanjiForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.fiftyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 50;
            this.selectionMethod = KanjiForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.allKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = Kanji.getNumberOfKnownKanji();
            this.selectionMethod = KanjiForTestSelectionMethod.ALL;
        } else if (this.notTenTimesGoodTestedKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = this.notTenTimesGoodTestedKanjiList.size();
            this.selectionMethod = KanjiForTestSelectionMethod.NOT_TEN_TIMES_GOOD_TESTED;
        } else if (this.lastFiftyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 50;
            this.selectionMethod = KanjiForTestSelectionMethod.LAST_N;
        } else if (this.lastThirtyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 30;
            this.selectionMethod = KanjiForTestSelectionMethod.LAST_N;
        } else if (this.lastTwentyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 20;
            this.selectionMethod = KanjiForTestSelectionMethod.LAST_N;
        } else if (this.lastFifteenKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 15;
            this.selectionMethod = KanjiForTestSelectionMethod.LAST_N;
        } else if (this.lastTenKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 10;
            this.selectionMethod = KanjiForTestSelectionMethod.LAST_N;
        } else if (this.lastFiveKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 5;
            this.selectionMethod = KanjiForTestSelectionMethod.LAST_N;
        } else if (this.oldestTestedFiftyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 50;
            this.selectionMethod = KanjiForTestSelectionMethod.OLDEST_TESTED_N;
        } else if (this.oldestTestedThirtyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 30;
            this.selectionMethod = KanjiForTestSelectionMethod.OLDEST_TESTED_N;
        } else if (this.oldestTestedTwentyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 20;
            this.selectionMethod = KanjiForTestSelectionMethod.OLDEST_TESTED_N;
        } else if (this.oldestTestedFifteenKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 15;
            this.selectionMethod = KanjiForTestSelectionMethod.OLDEST_TESTED_N;
        } else if (this.oldestTestedTenKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 10;
            this.selectionMethod = KanjiForTestSelectionMethod.OLDEST_TESTED_N;
        } else if (this.oldestTestedFiveKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 5;
            this.selectionMethod = KanjiForTestSelectionMethod.OLDEST_TESTED_N;
        } else if (this.mostSeldomTestedFiftyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 50;
            this.selectionMethod = KanjiForTestSelectionMethod.MOST_SELDOM_TESTED_N;
        } else if (this.mostSeldomTestedThirtyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 30;
            this.selectionMethod = KanjiForTestSelectionMethod.MOST_SELDOM_TESTED_N;
        } else if (this.mostSeldomTestedTwentyKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 20;
            this.selectionMethod = KanjiForTestSelectionMethod.MOST_SELDOM_TESTED_N;
        } else if (this.mostSeldomTestedFifteenKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 15;
            this.selectionMethod = KanjiForTestSelectionMethod.MOST_SELDOM_TESTED_N;
        } else if (this.mostSeldomTestedTenKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 10;
            this.selectionMethod = KanjiForTestSelectionMethod.MOST_SELDOM_TESTED_N;
        } else if (this.mostSeldomTestedFiveKanjiRadioButton.isSelected()) {
            this.numberOfKanjiToTest = 5;
            this.selectionMethod = KanjiForTestSelectionMethod.MOST_SELDOM_TESTED_N;
        } else {
            this.numberOfKanjiToTest = -1;
            this.selectionMethod = KanjiForTestSelectionMethod.UNKNOWN;
            String string2 = "Keine Anzahl an Kanji ausgew\u00e4hlt";
            String string3 = "Sie haben die Anzahl der abzufragenden Kanji nicht ausgew\u00e4hlt.";
            GuiTools.informUser(this.getWindowAsComponent(), string2, string3);
            return;
        }
        this.useOriginalKanjiOrder = this.useOriginalKanjiOrderCheckBox.isSelected();
        this.germanMeaningCaseSensitivity = this.germanMeaningCaseSensitivityCheckBox.isSelected();
        this.onLesungCaseSensitivity = this.onLesungCaseSensitivityCheckBox.isSelected();
        this.kunLesungCaseSensitivity = this.kunLesungCaseSensitivityCheckBox.isSelected();
        this.applied = true;
        this.quit();
    }

    public boolean isApplied() {
        return this.applied;
    }

    public List<Kanji> getKanjiList() {
        return this.kanjiList;
    }

    public int getNumberOfKanjiToTest() {
        return this.numberOfKanjiToTest;
    }

    public boolean isUseOriginalKanjiOrder() {
        return this.useOriginalKanjiOrder;
    }

    public KanjiForTestSelectionMethod getSelectionMethod() {
        return this.selectionMethod;
    }

    public boolean isGermanMeaningCaseSensitivity() {
        return this.germanMeaningCaseSensitivity;
    }

    public boolean isOnLesungCaseSensitivity() {
        return this.onLesungCaseSensitivity;
    }

    public boolean isKunLesungCaseSensitivity() {
        return this.kunLesungCaseSensitivity;
    }
}

