package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.datetime.date.ImmutualDate;

/**
 * Diese Klasse parst einen Datumswert aus einem String.
 *
 * @version 1.01     2021-03-19
 * @author Christian Dühl
 */

public class DateParser {

    private final List<DateParseMethod> methods;

    private final String dateToParse;

    public DateParser(String dateToParse) {
        this.dateToParse = dateToParse;
        methods = createDateParseMethodsList();
    }

    private List<DateParseMethod> createDateParseMethodsList() {
        List<DateParseMethod> methods = new ArrayList<>();

        methods.add(new DateParseMethodNormal(dateToParse));
        methods.add(new DateParseMethodUnix(dateToParse));
        methods.add(new DateParseMethodTwoDigitYear(dateToParse));
        methods.add(new DateParseMethodYYYYMMDD(dateToParse));
        methods.add(new DateParseMethodSlash(dateToParse));
        methods.add(new DateParseMethodMinus(dateToParse));

        /* Die folgenden Methoden später, sie fangen sonst Zahlen: */
        methods.add(new DateParseMethodMonthWordsBlanks(dateToParse));
        methods.add(new DateParseMethodMonthWordsBlanksShortYear(dateToParse));
        methods.add(new DateParseMethodMonthWordsHyphens(dateToParse));
        methods.add(new DateParseMethodMonthWordsHyphensShortYear(dateToParse));

        return methods;
    }

    public ImmutualDate parse() {
        for (DateParseMethod method : methods) {
            method.parse();
            if (method.isSuccessfull()) {
                return method.getParsedDate();
            }
        }
        return new ImmutualDate(0, 0, 0);
    }

}
