package de.duehl.basics.datetime.time.data;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Eine Hilfsklasse die Stunden, Minuten und Sekunden enthält.
 *
 * @version 1.01     2021-03-17
 * @author Christian Dühl
 */

public class HoursMinutesSeconds {

    private long hours;

    private final long minutes;

    private final long seconds;

    public HoursMinutesSeconds(long hours, long minutes, long seconds) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public long getHours() {
        return hours;
    }

    public long getMinutes() {
        return minutes;
    }

    public long getSeconds() {
        return seconds;
    }

    public void cutToSinceMidnight() {
        hours = hours % 24;
    }

    @Override
    public String toString() {
        return "HoursMinutesSeconds [hours=" + hours + ", minutes=" + minutes + ", seconds="
                + seconds + "]";
    }

    public String toFormattedString() {
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

}
