package de.duehl.basics.io.lock;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse lockt eine Datei und gibt den Lock wieder frei.
 *
 * Falls der Lock nicht auf Anhieb erhalten wird, wird eine gewisse Zeit lang immer wieder
 * versucht, den Lock zu erhalten.
 *
 * @version 1.01     2021-02-09
 * @author Christian Dühl
 */

public class WaitingFileLock extends WaitingLock<FileLock> {

    /**
     * Konstruktor.
     *
     * @param waitForLockSeconds
     *            Anzahl der Sekunden, die darauf gewartet wird, den Lock zu erhalten.
     * @param sleepBeforeRetryMilliseconds
     *            Anzahl der Millisekunden, die nach einem nicht erhaltenen Lock gewartet wird.
     * @param filename
     *            Dateiname
     */
    public WaitingFileLock(int waitForLockSeconds, int sleepBeforeRetryMilliseconds,
            String filename) {
        super(waitForLockSeconds, sleepBeforeRetryMilliseconds, new FileLock(filename));
    }

}
