package de.duehl.basics.currency;

/*
 * Copyright 2026 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.text.NumberString;

public class EuroToolsTest {

    @Test
    public void dmToEuroNumber1() {
        double dm = 1;
        double actual = EuroTools.dmToEuro(dm);
        double expected = 1 / 1.95583D;
        assertEquals(expected, actual, 0.0001D);
    }

    @Test
    public void euroToDmNumber1() {
        double euro = 1;
        double actual = EuroTools.euroToDm(euro);
        double expected = 1.95583D;
        assertEquals(expected, actual, 0.0001D);
    }

    @Test
    public void dmToEuroString1() {
        String dm = "1";
        String actual = EuroTools.dmToEuro(dm);
        double expectedDouble = 1 / 1.95583D;
        String expected = NumberString.twoDecimalPlacesTaupu(expectedDouble);
        assertEquals(expected, actual);

        String expected2 = "0,51";
        assertEquals(expected2, actual);
    }

    @Test
    public void dmToEuroString2() {
        String dm = "50.000,00";
        String actual = EuroTools.dmToEuro(dm);
        double expectedDouble = 50000 / 1.95583D;
        String expected = NumberString.twoDecimalPlacesTaupu(expectedDouble);
        assertEquals(expected, actual);

        String expected2 = "25.564,59";
        assertEquals(expected2, actual);
    }

}
