package de.duehl.basics.io;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

public class FileFromJarReaderTest {

    @Test
    public void test() {
        Class<?> clazz = this.getClass();
        String fileName = "JarFromFileReaderTestFile.txt";

        FileFromJarReader reader = new FileFromJarReader(clazz, fileName, Charset.UTF_8);
        List<String> words = reader.readFileToListOfStrings();
        reader.close();

        assertEquals(3, words.size());
        assertEquals("eins", words.get(0));
        assertEquals("zwei", words.get(1));
        assertEquals("drei", words.get(2));
    }

}
