package de.duehl.basics.logic;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class BulletinBoardCodeTest {

    @Test
    public void create() {
        BulletinBoardCode bbc = new BulletinBoardCode();
        assertTrue(null != bbc);
    }

    @Test
    public void bold() {
        BulletinBoardCode bbc = new BulletinBoardCode();
        String input = "[b]Hallo![/b]";
        String expected = "<strong>Hallo!</strong>";
        String actual = bbc.toHtml(input);
        assertEquals(expected, actual);
    }

    @Test
    public void italic1() {
        BulletinBoardCode bbc = new BulletinBoardCode();
        String input = "[i]Hallo![/i]";
        String expected = "<span style='font-style:italic;'>Hallo!</span>";
        String actual = bbc.toHtml(input);
        assertEquals(expected, actual);
    }

    @Test
    public void italic2() {
        BulletinBoardCode bbc = new BulletinBoardCode();
        String input = "[i]Hallo![/i]";
        String expected = "<i>Hallo!</i>";
        String actual = bbc.toHtmlForJava(input);
        assertEquals(expected, actual);
    }

}
