package de.duehl.basics.logic;

import static org.junit.Assert.*;

import org.junit.Test;

public class CheckResultTest {

    @Test
    public void aNewChecResultIsOk() {
        CheckResult checkResult = new CheckResult();
        assertTrue(checkResult.isOk());
    }

    @Test (expected = RuntimeException.class)
    public void gettingErrorTextOnANewChecResultThrowsException() {
        CheckResult checkResult = new CheckResult();
        checkResult.getErrorText();
    }

    @Test
    public void failingCheckResultIsNotOk() {
        CheckResult checkResult = new CheckResult();
        checkResult.failed("Da ging was schief!");
        assertFalse(checkResult.isOk());
    }

    @Test
    public void failingCheckResulthasFailed() {
        CheckResult checkResult = new CheckResult();
        checkResult.failed("Da ging was schief!");
        assertTrue(checkResult.hasFailed());
    }

    @Test (expected = IllegalArgumentException.class)
    public void failingWithoutErrorTextThrowsException() {
        CheckResult checkResult = new CheckResult();
        checkResult.failed("");
    }

    @Test (expected = NullPointerException.class)
    public void failingWithNullErrorTextThrowsException() {
        CheckResult checkResult = new CheckResult();
        checkResult.failed(null);
    }

    @Test
    public void getErrorText() {
        CheckResult checkResult = new CheckResult();
        String errorText = "Da ging was schief!";
        checkResult.failed(errorText);
        String actual = checkResult.getErrorText();
        String expected = errorText;
        assertEquals(expected, actual);
    }

    @Test
    public void getErrorTextAfterTwoFailures() {
        CheckResult checkResult = new CheckResult();

        String errorText1 = "Da ging was schief!";
        checkResult.failed(errorText1);

        String errorText2 = "Da ging noch was anderes schief!";
        checkResult.failed(errorText2);

        String actual = checkResult.getErrorText();
        String expected = errorText2;
        assertEquals(expected, actual);
    }

}
