package de.duehl.basics.start;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.zip.UnzipWith7ZipDirectProgramStart;

public class Testing7ZipUnzipping4WithDirectProgramStart {

    public static void main(String[] args) {
        String dir = "c:\\temp\\zipping_test5_ohne_Leerzeichen";

        //String zipFilename = FileHelper.concatPathes(dir, "daten_von_Hand_mit_7zip_verpackt.zip");
        String zipFilename = FileHelper.concatPathes(dir, "daten_per_Programm_verpackt.zip");

        String targetDir = FileHelper.concatPathes(dir, "entpackTestProgrammOhnePasswort");
        FileHelper.createDirectoryIfNotExists(targetDir);

        String sevenZipExecutable = "c:\\temp\\zipping_test3\\7-Zip\\7z.exe";
        UnzipWith7ZipDirectProgramStart unzip = new UnzipWith7ZipDirectProgramStart(
                sevenZipExecutable);
        unzip.unzip(zipFilename, targetDir);

        // funktioniert!
    }

}
