package de.duehl.basics.text.xml;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class NamedXmlParameterTest {

    @Test
    public void create() {
        String name = "parameter";
        String content = "wert";
        NamedXmlParameter param = new NamedXmlParameter(name, content);
        assertNotNull(param);
    }

    @Test
    public void getName() {
        String name = "parameter";
        String content = "wert";
        NamedXmlParameter param = new NamedXmlParameter(name, content);
        String actual = param.getName();
        String expected = "parameter";
        assertEquals(expected, actual);
    }

    @Test
    public void getContent() {
        String name = "parameter";
        String content = "wert";
        NamedXmlParameter param = new NamedXmlParameter(name, content);
        String actual = param.getContent();
        String expected = "wert";
        assertEquals(expected, actual);
    }

    @Test
    public void toStringTest() {
        String name = "parameter";
        String content = "wert";
        NamedXmlParameter param = new NamedXmlParameter(name, content);
        String actual = param.toString();
        String expected = "parameter=\"wert\"";
        assertEquals(expected, actual);
    }

}
