package de.duehl.basics.text.xml.own.data;

import de.duehl.basics.text.Text;
import de.duehl.basics.text.xml.own.OwnXmlHelper;
import de.duehl.basics.text.xml.own.XmlStorable;

public class Obstsorte implements XmlStorable {

    private final String name;

    public Obstsorte(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    @Override
    public String toXml() {
        return ""
                + "<obstsorte>" + Text.LINE_BREAK
                + "    <name>" + name + "</name>" + Text.LINE_BREAK
                + "</obstsorte>";
    }

    /** Erzeugt einen Aufgabenbereich aus einer Zeile aus einer XML-Datei. */
    public static Obstsorte createFromXmlLine(String line) {
        String name = OwnXmlHelper.readContentOfSingleUniqueXmlElementInXmlLine(
                "obstsorte", line);
        Obstsorte sector = new Obstsorte(name);
        return sector;
    }

}
