package de.duehl.swing.sevenzip;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.zip.sevenzip.SevenZipPathDeterminer;
import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.GuiTools;

/**
 * Diese Klasse stellt Tools rund um die Verwendung des Programms 7zip zur Verfügung.
 *
 * @version 1.01     2024-11-26
 * @author Christian Dühl
 */

public class SevenZipTools {

    /**
     * In dieser Methode versuche ich den Pfad zum Programm 7zip zum Auspacken von ZIP-Archiven zu
     * erstellen.
     * Dieses muss dazu auf dem Rechner des Benutzers installiert sein.
     *
     * Zunächst nehme ich den Namen in den Optionen, dort lege ich ihn nämlich ab, damit der
     * Benutzer nicht mehr als einmal auswählen muss, wo 7zip liegt.
     *
     * Falls dieser leer ist, versuche ich es mit dem SevenZipPathDeterminer, welcher Pfade prüft,
     * in denen ich das Programm auf unterschiedlichen Rechnern installiert habe.
     *
     * Ist dies ebenfalls erfolglos, frage ich den Benutzer nach dem Pfad der 7zip.exe-Datei.
     *
     * Wenn kein 7zip vorhanden ist, gebe ich den leeren String zurück.
     */
    public static String determine7ZipPath(String sevenZipPath) {
        String sevenZipPathOut = sevenZipPath;

        if (sevenZipPathOut.isEmpty() || !FileHelper.isFile(sevenZipPathOut)) {
            sevenZipPathOut = SevenZipPathDeterminer.determine7zipPath();
        }

        if (sevenZipPathOut.isEmpty() || !FileHelper.isFile(sevenZipPathOut)) {
            String title = "Bitte wählen sie die Datei 7zip.exe aus dem installierten Programm "
                    + "7zip aus.";
            sevenZipPathOut = GuiTools.openFileWithExtension(title, ".exe",
                    SystemTools.getHomeDirectory());
            if (sevenZipPathOut.isEmpty() || !FileHelper.isFile(sevenZipPathOut)) {
                sevenZipPathOut = "";
            }
            else {
                //options.setLastUsed7ZipDirectory(sevenZipPath);
            }
        }

        return sevenZipPathOut;
    }

}
