package de.duehl.swing.ui.buttons.painted;

import java.awt.Graphics2D;

/**
 * Diese Klasse stellt einen kleinen Schalter dar, der anzeigt, ob eine Liste zufällig abgespielt
 * wird.
 *
 * Die Zustände werden über das setzen der Farbe geregelt.
 *
 * @version 1.01     2025-07-26
 * @author Christian Dühl
 */

final public class ShuffleButton extends PaintedButton {

    private static final long serialVersionUID = 1L;

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintSymbol();
    }

    /**
     * Zeichnet zwei sich kreuzende Pfeile nach rechts.
     *
     * Da es dabei egal ist, ob horizontal oder vertikal, wird es in beiden Fällen verwendet.
     *
     * Es wird dabei nur ein Teil der normalerweise verwendeten Höhe genutzt
     */
    private void paintSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 2;

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        //int innerWidth = right - left;
        int innerHeight = lower - upper;

        int freeAreaY = innerHeight / 2;
        int yDelta = (int) (freeAreaY / 1.5);
        upper = upper + yDelta;
        lower = lower - yDelta;
        innerHeight = lower - upper;

        //graphics2.setStroke(new BasicStroke(3, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));

        int x1Down = left;  // Startpunkt
        int y1Down = upper; // Startpunkt
        int x2Down = right; // Endpunkt
        int y2Down = lower; // Endpunkt

        // Pfeillinie von oben nach unten
        graphics2.drawLine(x1Down, y1Down, x2Down, y2Down);

        // Pfeilspitze zeichnen
        drawArrowHead(graphics2, x1Down, y1Down, x2Down, y2Down);

        int x1Up = left;  // Startpunkt
        int y1Up = lower; // Startpunkt
        int x2Up = right; // Endpunkt
        int y2Up = upper; // Endpunkt

        // Pfeillinie von unten nach oben
        graphics2.drawLine(x1Up, y1Up, x2Up, y2Up);

        // Pfeilspitze zeichnen
        drawArrowHead(graphics2, x1Up, y1Up, x2Up, y2Up);
    }

    public static void drawArrowHead(Graphics2D g2, int x1, int y1, int x2, int y2) {
        double phi = Math.toRadians(30); // Winkel der Spitze
        int length = 4; // Länge der Spitzen

        double dy = y2 - y1;
        double dx = x2 - x1;
        double theta = Math.atan2(dy, dx);

        double x, y;
        for (int j = 0; j < 2; j++) {
            double rho = theta + (j == 0 ? phi : -phi);
            x = x2 - length * Math.cos(rho);
            y = y2 - length * Math.sin(rho);
            g2.drawLine(x2, y2, (int) x, (int) y);
        }
    }

}
