package de.duehl.swing.ui.components.selections;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import de.duehl.basics.text.Separator;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.layout.VerticalLayout;

/**
 * Diese Klasse stellt eine Auswahl der Trennern zur Verfügung.
 *
 * @version 1.01     2019-11-05
 * @author Christian Dühl
 */

public class SeparatorSelection {

    private static final int VERTICAL_SPACE = 2;

    private ButtonGroup group;
    private List<JRadioButton> separatorButtons;

    /** Der hier erzeugte Panel mit den Separator-Buttons. */
    private JPanel panel;

    public SeparatorSelection(String title) {
        group = new ButtonGroup();
        separatorButtons = new ArrayList<>();

        for (Separator separator : Separator.values()) {
            separatorButtons.add(new JRadioButton(separator.name()));
        }
        select(Separator.TABULATOR);

        panel = new JPanel();
        panel.setLayout(new VerticalLayout(VERTICAL_SPACE, VerticalLayout.BOTH));
        GuiTools.createTitle(title, panel);

        addToGroup();
        addToPanel();
    }

    private void addToGroup() {
        for (JRadioButton radioButton : separatorButtons) {
            group.add(radioButton);
        }
    }

    private void addToPanel() {
        for (JRadioButton radioButton : separatorButtons) {
            panel.add(radioButton);
        }
    }

    /** Getter für den hier erzeugten Panel mit den Separator-Buttons. */
    public JPanel getPanel() {
        return panel;
    }

    /** Legt die Auswahl auf den übergebenen Trenner fest. */
    public void select(Separator separator) {
        String text = separator.name();
        for (JRadioButton radioButton : separatorButtons) {
            String buttonText = radioButton.getText();
            radioButton.setSelected(buttonText.equals(text));
        }
    }

    /** Ermittelt den ausgewählten Trenner. */
    public Separator getSelected() {
        for (JRadioButton radioButton : separatorButtons) {
            if (radioButton.isSelected()) {
                String buttonText = radioButton.getText();
                return Separator.detectFromNameString(buttonText);
            }
        }

        throw new RuntimeException("Kein Button ausgewählt.");
    }

    /** Setzt den Tooltip. */
    public void setToolTipText(String tooltip) {
        panel.setToolTipText(tooltip);
        for (JRadioButton button : separatorButtons) {
            button.setToolTipText(tooltip);
        }
    }

    /** Fügt ActionListener zu den Buttons hinzu. */
    public void addActionListener(ActionListener listener) {
        for (JRadioButton button : separatorButtons) {
            button.addActionListener(listener);
        }
    }

}
