package de.duehl.swing.ui.filter.method;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für eine Klasse, welche eine Fabrik darstellt, die je nach dem
 * übergebenen Filter-Typ eine entsprechende Filter-Methoden-Klasse herstellt.
 *
 * @version 1.01     2020-11-04
 * @author Christian Dühl
 */

public interface FilterMethodFabricable<Data, Type> {

    /**
     * Eigentliche Fabrikmethode für die einfachen Filter.
     *
     * @param type
     *            Typ des Filters.
     * @return Filtermethode.
     * @throws FilterException
     *             Falls der Typ des Filters unbekannt oder kein einfacher Filtertyp ist.
     */
    Method<Data> buildMethod(Type type);

    /**
     * Fabrikmethode für die Filter mit Suchtext.
     *
     * @param type
     *            Typ des Filters.
     * @param searchForMe
     *            Der zu suchende Text.
     * @return Filtermethode.
     * @throws FilterException
     *             Falls der Typ des Filters unbekannt oder kein Filtertyp mit Eingabe ist.
     */
    Method<Data> buildInputMethod(Type type, String searchForMe);

}
