package de.duehl.swing.ui.geometry;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse steht für einen zweidimensionalen Punkt in Pixeln.
 *
 * @version 1.01     2017-02-23
 * @author Christian Dühl
 */

public class PixelPoint {

    /** x-Koordinate des Punktes. */
    private final int x;

    /** y-Koordinate des Punktes. */
    private final int y;

    /** Default-Konstruktor. Erzeugt den Nullpunkt. */
    public PixelPoint() {
        this(0, 0);
    }

    /**
     * Konstruktor.
     *
     * @param x
     *            x-Koordinate des Punktes.
     * @param y
     *            y-Koordinate des Punktes.
     */
    public PixelPoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    /**
     * Copy-Konstruktor, kopiert die Koordinaten des gegebenen Punktes.
     *
     * @param that
     *            Punkt, von dem die Koordinaten kopiert werden sollen.
     */
    public PixelPoint(PixelPoint that) {
        this.x = that.x;
        this.y = that.y;
    }

    /**
     * Konstruktor, der die Koordinaten aus einem AWT-Punkt entnimmt.
     *
     * @param point
     *            AWT-Punkt.
     */
    public PixelPoint(java.awt.Point point) {
        x = (int) point.getX();
        y = (int) point.getY();
    }

    /** Getter für die x-Koordinate. */
    public int getX() {
        return x;
    }

    /** Getter für die y-Koordinate. */
    public int getY() {
        return y;
    }

    @Override
    public String toString() {
        return "PixelPoint [x=" + x + ", y=" + y + "]";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + x;
        result = prime * result + y;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        PixelPoint other = (PixelPoint) obj;
        if (x != other.x) {
            return false;
        }
        if (y != other.y) {
            return false;
        }
        return true;
    }

}
