package de.duehl.swing.ui.io.lock;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.lock.MultipleStartLock;

/**
 * Diese Klasse kümmert sich um eine Lockdatei, welche verhindert, dass mehrere Programmaufrufe zur
 * gleichen Zeit stattfinden.
 *
 * Die Klasse de.duehl.basics.io.lock.MultipleStartLock wird dabei um eine bequeme Methode zum
 * wiederholten Versuchen das Lock zu erhalten ergänzt.
 *
 * @version 1.01     2021-02-09
 * @author Christian Dühl
 */

public class InteractiveProgramMultipleStartLock extends InteractiveProgramLock<MultipleStartLock> {

    /** Name des Programms, das mit der Lockdatei vor mehrfachen Aufrufen geschützt wird. */
    private final String programName;

    /**
     * Konstruktor.
     *
     * @param programName
     *            Name des Programms, das mit der Lockdatei vor mehrfachen Aufrufen geschützt wird.
     * @param lockFilename
     *            Name der Sperrdatei, die einen mehrfachen Start verhindert.
     */
    public InteractiveProgramMultipleStartLock(String programName, String lockFilename) {
        super(new MultipleStartLock(lockFilename));
        this.programName = programName;
    }

    @Override
    protected String createNoLockGainedDialogTitle() {
        return programName + " läuft bereits!";
    }

    @Override
    protected String createNoLockGainedDialogMessage() {
        return "Der Programmstart wurde abgebrochen, da " + programName
                + " bereits läuft.\n\n"
                + "Die zugehörige Lockdatei ist:\n\n"
                + "\t" + getFilename() + "\n\n"
                + "Bitte entscheiden Sie, wie weiter vogegangen werden soll. "
                + "Die zur Verfügung stehenden Möglichkeiten lauten:\n"
                + "\t" + "1) Abbruch des Programms" + "\n"
                + "\t" + "2) Lock entfernen und den Schritt wiederholen" + "\n"
                + "\t" + "3) Schritt wiederhoilen, ohne den Lock zu entfernen" + "\n";
    }

}
