package de.duehl.swing.ui.move.data;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für eine Klasse, die Buttons zum vertikalen Verschieben benutzt.
 *
 * @version 1.01     2025-06-17
 * @author Christian Dühl
 */

public interface VerticalMoveButtonsUser {

    /** Gibt an, ob die nutzende Ui das Element mit diesen Buttons nach oben bewegt werden kann. */
    boolean canMoveButtonsUserMoveUp();

    /** Gibt an, ob die nutzende Ui das Element mit diesen Buttons nach unten bewegt werden kann. */
    boolean canMoveButtonsUserMoveDown();

    /** Verschiebt das Element mit diesen Buttons an die erste Stelle. */
    void moveMoveButtonsUserToFirst();

    /** Verschiebt das Element mit diesen Buttons nach oben. */
    void moveMoveButtonsUserUp();

    /** Verschiebt das Element mit diesen Buttons nach unten. */
    void moveMoveButtonsUserDown();

    /** Verschiebt das Element mit diesen Buttons an die letzte Stelle. */
    void moveMoveButtonsUserToLast();

}
