package de.duehl.swing.ui.start;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.elements.textfield.EnterTextField;

/**
 * Diese Klasse testet das EnterTextField-Element.
 *
 * @version 1.01     2017-12-15
 * @author Christian Dühl
 */

public class EnterTextFieldTest {

    /** Die zu testenden Reiter. */
    private EnterTextField textField;

    /** Konstruktor. */
    public EnterTextFieldTest() {
        textField = new EnterTextField(text -> enterPressed(text));
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private void enterPressed(String text) {
        System.out.println("Eingegebener Text: '" + text + "'");
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("EnterTextField Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0,  1));

        frame.add(textField);

        frame.setPreferredSize(new Dimension(300, 100));
        frame.pack();
        frame.setVisible(true);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new EnterTextFieldTest();
    }

}

