package de.duehl.threads.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.threads.BusyRunnable;
import de.duehl.threads.timed.TimedThreadRunner;
import de.duehl.threads.timed.TimedThreadRunner.TaskState;

public class TimedThread1 {

    public static void main(String[] args) {
        int secondsTaskIsRunning = 10;
        int secondsBeforeKill = 5;
        int secondsBetweenWatching = 2;

        BusyRunnable runnable = new BusyRunnable(secondsTaskIsRunning);
        TimedThreadRunner runner = new TimedThreadRunner(secondsBeforeKill,
                1000L * secondsBetweenWatching, runnable);
        System.out.println("VOR runner.runTask()");
        runner.runTask();
        System.out.println("NACH runner.runTask()");
        TaskState state = runner.getTaskState();
        System.out.println("State : " + state);
    }

}

/*

VOR runner.runTask()
Prüfung zu Beginn in Ordnung.
Warte 2 Sekunden...
- BusyRunnable Berechnung: 5
- BusyRunnable Berechnung: 23
- BusyRunnable Berechnung: 37
- BusyRunnable Berechnung: 61
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 5
    Bisher      : 2
Warte 2 Sekunden...
- BusyRunnable Berechnung: 63
- BusyRunnable Berechnung: 71
- BusyRunnable Berechnung: 85
- BusyRunnable Berechnung: 100
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 5
    Bisher      : 4
Warte 2 Sekunden...
- BusyRunnable Berechnung: 106
- BusyRunnable Berechnung: 123
- BusyRunnable Berechnung: 126
- BusyRunnable Berechnung: 130
Zeit abgelaufen! Thread muss abgewürgt werden...
NACH runner.runTask()
State : CANCELLED

*/