package de.duehl.vocabulary.japanese.data.symbol;

/**
 * Diese Klasse stellt einige japanische Satzzeichen (in UTF-Zeichen) dar.
 *
 * @version 1.01     2025-02-02
 * @author Christian Dühl
 */

public enum Punctuation {

    OPENING_QUOTE("「"),
    CLOSING_QUOTE("」"),
    POINT("。"),
    COMMA("、"),
    NAKAGURU("・"),

    CHOONPU_1("-"),
    CHOONPU_2("ー"),
    CHOONPU_3("―"),
    CHOONPU_4("ー"),
    CHOONPU_5("―"),

    ODORIJI("々"),
    MONATSDAUER_KA("ヶ"),
    QUESTION_MARK("？"),
    EXKLAMATION_MARK("！"),
    ;

    /** Das Zeichen in UTF-8 Darstellung. */
    private final String character;

    /**
     * Konstruktor.
     *
     * @param character
     *            Das Zeichen in UTF-8 Darstellung.
     */
    private Punctuation(String character) {
        this.character = character;
    }

    /** Getter für das Zeichen in UTF-8 Darstellung. */
    public String getCharacter() {
        return character;
    }

}
