package de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data;

import java.util.ArrayList;
import java.util.List;

import de.duehl.vocabulary.japanese.data.symbol.Kanji;

/**
 * Diese Klasse stellt das Ergebnis der Bewertung einer einzelnen Abfrage eines Kanji dar.
 *
 * @version 1.01     2025-09-14
 * @author Christian Dühl
 */

public class SingleUserInputKanjiCheckResult {

    /** Das Kanji welches abgefragt wurde. */
    private final Kanji kanji;

    /** Die Bereiche in denen Fehler gemacht wurden. */
    private List<KanjiUserInputType> wrongKanjiUserInputTypes;

    /** Die Beschreibung der Fehler, fall welche gemacht wurden. */
    private String errorDescription;

    /** Der Hinweis auf Abweichungen, die keine Fehler sind. */
    private String memorandum;

    /** Gibt an, ob alles richtig ist. */
    private boolean ok;

    /** Konstruktor. */
    public SingleUserInputKanjiCheckResult(Kanji kanji) {
        this.kanji = kanji;

        ok = true;
        errorDescription = "";
        memorandum = "";
        wrongKanjiUserInputTypes = new ArrayList<>();
    }

    /** Getter für das Kanji welches abgefragt wurde. */
    public Kanji getKanji() {
        return kanji;
    }

    /** Getter für die Beschreibung der Fehler, falls welche gemacht wurden. */
    public String getErrorDescription() {
        return errorDescription;
    }

    /** Setter für die Beschreibung der Fehler, falls welche gemacht wurden. */
    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    /** Getter für die Bereiche in denen Fehler gemacht wurden. */
    public List<KanjiUserInputType> getWrongKanjiUserInputTypes() {
        return wrongKanjiUserInputTypes;
    }

    /** Setter für die Bereiche in denen Fehler gemacht wurden. */
    public void setWrongKanjiUserInputTypes(List<KanjiUserInputType> wrongKanjiUserInputTypes) {
        this.wrongKanjiUserInputTypes = wrongKanjiUserInputTypes;
    }

    /** Getter für den Hinweis auf Abweichungen, die keine Fehler sind. */
    public String getMemorandum() {
        return memorandum;
    }

    /** Setter für den Hinweis auf Abweichungen, die keine Fehler sind. */
    public void setMemorandum(String memorandum) {
        this.memorandum = memorandum;
    }

    /** Gibt an, ob alles richtig ist. */
    public boolean isOk() {
        return ok;
    }

    /** Legt fest, ob alles richtig ist. */
    public void setOk(boolean ok) {
        this.ok = ok;
    }

    @Override
    public String toString() {
        return "SingleUserInputKanjiCheckResult [kanji=" + kanji + ", wrongKanjiUserInputTypes="
                + wrongKanjiUserInputTypes + ", errorDescription=" + errorDescription
                + ", memorandum=" + memorandum + ", ok=" + ok + "]";
    }

}
