package de.duehl.vocabulary.japanese.tools.data;

public class VocableSortData {

    private final int lastCorrectAgoInDays;

    private final int ageInDays;

    private final double lastAnswersValue;

    private final int countLastCorrectAnswers;

    private final int countLastIncorrectAnswers;

    private final int testCount;

    public VocableSortData(int lastCorrectAgoInDays, int ageInDays, double lastAnswersValue,
            int countLastCorrectAnswers, int countLastIncorrectAnswers, int testCount) {
        this.lastCorrectAgoInDays = lastCorrectAgoInDays;
        this.ageInDays = ageInDays;
        this.lastAnswersValue = lastAnswersValue;
        this.countLastCorrectAnswers = countLastCorrectAnswers;
        this.countLastIncorrectAnswers = countLastIncorrectAnswers;
        this.testCount = testCount;
    }

    public int getLastCorrectAgoInDays() {
        return lastCorrectAgoInDays;
    }

    public int getAgeInDays() {
        return ageInDays;
    }

    public double getLastAnswersValue() {
        return lastAnswersValue;
    }

    public int getCountLastCorrectAnswers() {
        return countLastCorrectAnswers;
    }

    public int getCountLastIncorrectAnswers() {
        return countLastIncorrectAnswers;
    }

    public int getTestCount() {
        return testCount;
    }

    @Override
    public String toString() {
        return "VocableSortData [lastCorrectAgoInDays=" + lastCorrectAgoInDays + ", ageInDays="
                + ageInDays + ", lastAnswersValue=" + lastAnswersValue
                + ", countLastCorrectAnswers=" + countLastCorrectAnswers
                + ", countLastInCorrectAnswers=" + countLastIncorrectAnswers + ", testCount="
                + testCount + "]";
    }

}
