package de.duehl.vocabulary.japanese.ui.data;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;

import de.duehl.basics.logic.ErrorHandler;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.dialogs.base.additional.LocationGetter;
import de.duehl.vocabulary.japanese.ui.components.data.OwnListsPartActualizer;

/**
 * Diese Klasse steht für Klassen oder Interfaces mit häufig verwendeten Funktionen der grafischen
 * Oberfläche des Vokabeltrainers.
 *
 * @version 1.01     2025-11-27
 * @author Christian Dühl
 */

public class FumikoUiObjects {

    /** Das Objekt, welches in der Statusbar der Gui eine Nachricht anzeigen kann. */
    private final MessageSetter messageSetter;

    /** Die Oberfläche des Vokabeltrainers als Component. */
    private final Component windowAsComponent;

    /** Die Oberfläche, welche diese Klasse aufruft, auf der man eine GlassPane anzeigen kann. */
    private final LongTimeProcessInformer informer;

    /** Der passender ErrorHandler, der sich auch um die GlassPane kümmert. */
    private final ErrorHandler errorHandler;

    /** Das Objekt das die Darstellung der eigenen Listen in der Gui aktualisiert. */
    private final OwnListsPartActualizer ownListsPartActualizer;

    /** Das Objekt, das die aktuelle Position der Oberfläche zurück geben kann. */
    private final LocationGetter locationGetter;

    /** Das Icon für das Programm. */
    private final Image programImage;

    /**
     * Konstruktor.
     *
     * @param messageSetter
     *            Das Objekt, welches in der Statusbar der Gui eine Nachricht anzeigen kann.
     * @param windowAsComponent
     *            Die Oberfläche des Vokabeltrainers als Component.
     * @param informer
     *            Die Oberfläche, welche diese Klasse aufruft, auf der man eine GlassPane anzeigen
     *            kann.
     * @param errorHandler
     *            Der passender ErrorHandler, der sich auch um die GlassPane kümmert.
     * @param ownListsPartActualizer
     *            Das Objekt das die Darstellung der eigenen Listen in der Gui aktualisiert.
     * @param locationGetter
     *            Das Objekt, das die aktuelle Position der Oberfläche zurück geben kann.
     * @param programImage
     *            Das Icon für das Programm.
     */
    public FumikoUiObjects(MessageSetter messageSetter, Component windowAsComponent,
            LongTimeProcessInformer informer, ErrorHandler errorHandler,
            OwnListsPartActualizer ownListsPartActualizer, LocationGetter locationGetter,
            Image programImage) {
        this.messageSetter = messageSetter;
        this.windowAsComponent = windowAsComponent;
        this.informer = informer;
        this.errorHandler = errorHandler;
        this.ownListsPartActualizer = ownListsPartActualizer;
        this.locationGetter = locationGetter;
        this.programImage = programImage;
    }

    /** Getter für das Objekt, welches in der Statusbar der Gui eine Nachricht anzeigen kann. */
    public MessageSetter getMessageSetter() {
        return messageSetter;
    }

    /** Getter für die Oberfläche des Vokabeltrainers als Component. */
    public Component getWindowAsComponent() {
        return windowAsComponent;
    }

    /**
     * Getter für die Oberfläche, welche diese Klasse aufruft, auf der man eine GlassPane anzeigen
     * kann.
     */
    public LongTimeProcessInformer getInformer() {
        return informer;
    }

    /** Getter für den passenden ErrorHandler, der sich auch um die GlassPane kümmert. */
    public ErrorHandler getErrorHandler() {
        return errorHandler;
    }

    /** Getter für das Objekt das die Darstellung der eigenen Listen in der Gui aktualisiert. */
    public OwnListsPartActualizer getOwnListsPartActualizer() {
        return ownListsPartActualizer;
    }

    /**
     * Getter für die aktuelle Position der grafischen Oberfläche des Vokabeltrainers.
     *
     * Funktioniert auch, wenn der Benutzer die Position verschoben hat.
     */
    public Point getGuiLocation() {
        return locationGetter.getLocation();
    }

    /** Getter für das Icon für das Programm. */
    public Image getProgramImage() {
        return programImage;
    }

}
