package de.duehl.vocabulary.japanese.ui.dialog.kanji.display.findlists;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.text.TextViewer;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;

/**
 * Diese Klasse findet zu einem Kanji alle Kanji-Mengen, in denen dieses Kanji vorkommt.
 *
 * @version 1.01     2025-11-21
 * @author Christian Dühl
 */

public class SetsWithKanjiFinder {

    /** Die Datenstrukturen des Vokabeltrainers. */
    private final FumikoDataStructures dataStructures;

    /**
     * Der modale oder nicht modale Dialog bzw., Frame, der den Panel nutzt, welcher diese Klasse
     * verwendet.
     */
    private final Component thisPanelUsingDialog;

    /**
     * Konstruktor.
     *
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param thisPanelUsingDialog
     *            Der modale oder nicht modale Dialog bzw., Frame, der den Panel nutzt, welcher
     *            diese Klasse verwendet.
     */
    public SetsWithKanjiFinder(FumikoDataStructures dataStructures,  Component thisPanelUsingDialog) {
        this.dataStructures = dataStructures;
        this.thisPanelUsingDialog = thisPanelUsingDialog;
    }

    /** Zeigt zum übergebenen Kanji alle Kanji-Mengen an, die dieses Kanji enthalten. */
    public void findKanjiSetsWithKanji(Kanji kanji) {
        List<KanjiSet> kanjiSets = dataStructures.getKanjiSets();

        List<String> names = new ArrayList<>();
        for (KanjiSet kanjiSet : kanjiSets) {
            if (kanjiSet.containes(kanji)) {
                names.add(kanjiSet.getName());
            }
        }

        if (names.isEmpty()) {
            GuiTools.informUser(thisPanelUsingDialog, "Keine Kanji-Menge gefunden.", ""
                    + "Das Kanji 「" + kanji.getCharacter() + "」 kommt in keiner Kanji-Menge vor.");
        }
        else {
            String text = "Das Kanji 「" + kanji.getCharacter() + "」 kommt in den folgenden "
                    + "Kanji-Mengen vor:\n\n"
                    + Text.joinWithLineBreak(names);
            TextViewer viewer = new TextViewer(
                    "Kanji-Mengen mit dem Kanji 「" + kanji.getCharacter() + "」",
                    thisPanelUsingDialog.getLocation());
            viewer.setText(text);
            viewer.setVisible(true);
        }
    }

}
