package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.findlists;

import java.awt.Component;
import java.util.List;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.text.TextViewer;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;

/**
 * Diese Klasse findet zu einer Vokabel alle eigenen Listen, in denen die Vokabel vorkommt.
 *
 * @version 1.01     2025-11-21
 * @author Christian Dühl
 */

class ListsWithVocableFinder {

    /** Die Datenstrukturen des Vokabeltrainers. */
    private final FumikoDataStructures dataStructures;

    /**
     * Der modale oder nicht modale Dialog bzw., Frame, der den Panel nutzt, welcher diese Klasse
     * verwendet.
     */
    private final Component thisPanelUsingDialog;

    /**
     * Konstruktor.
     *
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param thisPanelUsingDialog
     *            Der modale oder nicht modale Dialog bzw., Frame, der den Panel nutzt, welcher
     *            diese Klasse verwendet.
     */
    public ListsWithVocableFinder(FumikoDataStructures dataStructures,
            Component thisPanelUsingDialog) {
        this.dataStructures = dataStructures;
        this.thisPanelUsingDialog = thisPanelUsingDialog;
    }

    /** Zeigt zur übergebenen Vokabel alle Listen an, die diese Vokabel enthalten. */
    public void findListsWithVocable(Vocable vocable) {
        String kanji = vocable.getKanji();
        String kana = vocable.getKana();
        String vocableText = kanji.isBlank()
                ? kana
                : kanji + " (" + kana + ")";

        OwnLists ownLists = dataStructures.getOwnLists();
        List<String> names =  ownLists .findNamesOfListsWithVocable(vocable);
        if (names.isEmpty()) {
            GuiTools.informUser(thisPanelUsingDialog, "Keine Liste gefunden.", ""
                    + vocableText + "\n\n"
                    + "Die Vokabel kommt in keiner Liste vor.");
        }
        else {
            String text = "Die Vokabel " + vocableText + " kommt in den folgenden Listen vor:\n\n"
                    + Text.joinWithLineBreak(names);
            TextViewer viewer = new TextViewer("Listen mit der Vokabel",
                    thisPanelUsingDialog.getLocation());
            viewer.setText(text);
            viewer.setVisible(true);
        }
    }

}
